/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.NikonType1MakernoteDirectory;

public class NikonType1MakernoteDescriptor
extends TagDescriptor<NikonType1MakernoteDirectory> {
    public NikonType1MakernoteDescriptor(@NotNull NikonType1MakernoteDirectory nikonType1MakernoteDirectory) {
        super(nikonType1MakernoteDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 3: {
                return this.getQualityDescription();
            }
            case 4: {
                return this.getColorModeDescription();
            }
            case 5: {
                return this.getImageAdjustmentDescription();
            }
            case 6: {
                return this.getCcdSensitivityDescription();
            }
            case 7: {
                return this.getWhiteBalanceDescription();
            }
            case 8: {
                return this.getFocusDescription();
            }
            case 10: {
                return this.getDigitalZoomDescription();
            }
            case 11: {
                return this.getConverterDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getConverterDescription() {
        Integer n = ((NikonType1MakernoteDirectory)this._directory).getInteger(11);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Fisheye converter";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getDigitalZoomDescription() {
        Rational rational = ((NikonType1MakernoteDirectory)this._directory).getRational(10);
        if (rational == null) {
            return null;
        }
        if (rational.getNumerator() == 0L) {
            return "No digital zoom";
        }
        return rational.toSimpleString(true) + "x digital zoom";
    }

    @Nullable
    public String getFocusDescription() {
        Rational rational = ((NikonType1MakernoteDirectory)this._directory).getRational(8);
        if (rational == null) {
            return null;
        }
        if (rational.getNumerator() == 1L && rational.getDenominator() == 0L) {
            return "Infinite";
        }
        return rational.toSimpleString(true);
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer n = ((NikonType1MakernoteDirectory)this._directory).getInteger(7);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Preset";
            }
            case 2: {
                return "Daylight";
            }
            case 3: {
                return "Incandescence";
            }
            case 4: {
                return "Florescence";
            }
            case 5: {
                return "Cloudy";
            }
            case 6: {
                return "SpeedLight";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getCcdSensitivityDescription() {
        Integer n = ((NikonType1MakernoteDirectory)this._directory).getInteger(6);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "ISO80";
            }
            case 2: {
                return "ISO160";
            }
            case 4: {
                return "ISO320";
            }
            case 5: {
                return "ISO100";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getImageAdjustmentDescription() {
        Integer n = ((NikonType1MakernoteDirectory)this._directory).getInteger(5);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Bright +";
            }
            case 2: {
                return "Bright -";
            }
            case 3: {
                return "Contrast +";
            }
            case 4: {
                return "Contrast -";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getColorModeDescription() {
        Integer n = ((NikonType1MakernoteDirectory)this._directory).getInteger(4);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Color";
            }
            case 2: {
                return "Monochrome";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getQualityDescription() {
        Integer n = ((NikonType1MakernoteDirectory)this._directory).getInteger(3);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "VGA Basic";
            }
            case 2: {
                return "VGA Normal";
            }
            case 3: {
                return "VGA Fine";
            }
            case 4: {
                return "SXGA Basic";
            }
            case 5: {
                return "SXGA Normal";
            }
            case 6: {
                return "SXGA Fine";
            }
        }
        return "Unknown (" + n + ")";
    }
}

