/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceParser;
import com.android.utils.ILogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXException;

public class UserDeviceManager
implements Disposable {
    private final VirtualFileAdapter myListener = new VirtualFileAdapter(){

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/uipreview/UserDeviceManager$1", "contentsChanged"));
            }
            VirtualFile file = event.getFile();
            if (UserDeviceManager.this.myUserDevicesFile != null && "devices.xml".equals(file.getName()) && FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)UserDeviceManager.this.myUserDevicesFile.getPath()), (String)file.getPath())) {
                UserDeviceManager.this.userDevicesChanged();
            }
        }
    };
    private boolean myUserDevicesParsed;
    private File myUserDevicesFile;
    private static Set<String> ourWatchedRoots = new HashSet();

    public UserDeviceManager() {
        LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)this.myListener);
    }

    protected void userDevicesChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Device> parseUserDevices(@NotNull ILogger logger) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/uipreview/UserDeviceManager", "parseUserDevices"));
        }
        File userDevicesFile = this.getUserDevicesFile(logger);
        if (userDevicesFile == null) {
            List<Device> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/UserDeviceManager", "parseUserDevices"));
            }
            return list;
        }
        VirtualFile vUserDeviceFile = LocalFileSystem.getInstance().findFileByIoFile(userDevicesFile);
        if (vUserDeviceFile == null) {
            List<Device> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/UserDeviceManager", "parseUserDevices"));
            }
            return list;
        }
        ArrayList<Device> userDevices = new ArrayList<Device>();
        try {
            if (userDevicesFile.exists()) {
                userDevices.addAll(DeviceParser.parse((File)userDevicesFile));
            }
        }
        catch (SAXException e) {
            if (this.myUserDevicesParsed) {
                logger.error((Throwable)e, "Error parsing " + userDevicesFile.getAbsolutePath(), new Object[0]);
            } else {
                String newName = userDevicesFile.getAbsoluteFile() + ".old";
                File renamedConfig = new File(newName);
                int i = 0;
                while (renamedConfig.exists()) {
                    renamedConfig = new File(newName + '.' + i);
                    ++i;
                }
                logger.error((Throwable)e, "Error parsing " + userDevicesFile.getAbsolutePath() + ", backing up to " + renamedConfig.getAbsolutePath(), new Object[0]);
                if (!userDevicesFile.renameTo(renamedConfig)) {
                    logger.error((Throwable)e, "Cannot rename file " + userDevicesFile.getAbsolutePath() + " to " + renamedConfig.getAbsolutePath(), new Object[0]);
                }
            }
        }
        catch (ParserConfigurationException e) {
            logger.error(null, "Error parsing " + userDevicesFile.getAbsolutePath(), new Object[0]);
        }
        catch (IOException e) {
            logger.error(null, "Error parsing " + userDevicesFile.getAbsolutePath(), new Object[0]);
        }
        finally {
            this.myUserDevicesParsed = true;
        }
        ArrayList<Device> arrayList = userDevices;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/UserDeviceManager", "parseUserDevices"));
        }
        return arrayList;
    }

    private File getUserDevicesFile(ILogger logger) {
        if (this.myUserDevicesFile == null) {
            try {
                String myFolderToStoreDevicesXml = AndroidLocation.getFolder();
                this.myUserDevicesFile = new File(myFolderToStoreDevicesXml, "devices.xml");
            }
            catch (AndroidLocation.AndroidLocationException e) {
                logger.warning("Couldn't load user devices: " + e.getMessage(), new Object[0]);
                this.myUserDevicesFile = null;
                return null;
            }
            UserDeviceManager.addDevicesXmlWatchedRootIfNecessary(this.myUserDevicesFile);
        }
        return this.myUserDevicesFile;
    }

    private static void addDevicesXmlWatchedRootIfNecessary(@NotNull File root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/uipreview/UserDeviceManager", "addDevicesXmlWatchedRootIfNecessary"));
        }
        String path = FileUtil.toSystemIndependentName((String)root.getPath());
        if (ourWatchedRoots.add(path)) {
            LocalFileSystem.getInstance().addRootToWatch(path, true);
        }
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeVirtualFileListener((VirtualFileListener)this.myListener);
    }
}

