/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.Variant;
import com.android.ide.common.rendering.LayoutLibrary;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.rendering.AarResourceClassRegistry;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.RenderClassLoader;
import com.android.utils.SdkUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectClassLoader
extends RenderClassLoader {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.uipreview.ProjectClassLoader");
    private final Module myModule;

    public ProjectClassLoader(@Nullable ClassLoader parentClassLoader, Module module) {
        super(parentClassLoader);
        this.myModule = module;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            byte[] data;
            int index;
            if (!(this.myInsideJarClassLoader || (index = name.lastIndexOf(46)) == -1 || name.charAt(index + 1) != 'R' || index != name.length() - 2 && name.charAt(index + 2) != '$' || index <= 1 || (data = AarResourceClassRegistry.get().findClassDefinition(name)) == null)) {
                return this.defineClass(null, data, 0, data.length);
            }
            throw e;
        }
    }

    @Nullable
    public static ClassLoader create(IAndroidTarget target, Module module) throws Exception {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(module);
        if (androidPlatform == null) {
            return null;
        }
        AndroidTargetData targetData = androidPlatform.getSdkData().getTargetData(target);
        LayoutLibrary library = targetData.getLayoutLibrary(module.getProject());
        if (library == null) {
            return null;
        }
        return new ProjectClassLoader(library.getClassLoader(), module);
    }

    @Override
    @NotNull
    protected Class<?> load(String name) throws ClassNotFoundException {
        Class<?> aClass = this.loadClassFromModuleOrDependency(this.myModule, name, (Set<Module>)new HashSet());
        if (aClass != null) {
            Class<?> clazz = aClass;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ProjectClassLoader", "load"));
            }
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    @Nullable
    private Class<?> loadClassFromModuleOrDependency(Module module, String name, Set<Module> visited) {
        if (!visited.add(module)) {
            return null;
        }
        Class<?> aClass = this.loadClassFromModule(module, name);
        if (aClass != null) {
            return aClass;
        }
        aClass = this.loadClassFromJar(name);
        if (aClass != null) {
            return aClass;
        }
        for (Module depModule : ModuleRootManager.getInstance((Module)module).getDependencies(false)) {
            aClass = this.loadClassFromModuleOrDependency(depModule, name, visited);
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    @Nullable
    private Class<?> loadClassFromModule(Module module, String name) {
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension == null) {
            return null;
        }
        VirtualFile vOutFolder = extension.getCompilerOutputPath();
        if (vOutFolder == null) {
            IdeaAndroidProject gradleProject;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet != null && facet.isGradleProject() && (gradleProject = facet.getIdeaAndroidProject()) != null) {
                Class<?> localClass;
                File outFolder;
                Variant variant = gradleProject.getSelectedVariant();
                String variantName = variant.getName();
                AndroidArtifact mainArtifactInfo = variant.getMainArtifact();
                File classesFolder = mainArtifactInfo.getClassesFolder();
                if (classesFolder == null) {
                    AndroidArtifactOutput output = GradleUtil.getOutput(mainArtifactInfo);
                    File file = output.getOutputFile();
                    File buildFolder = file.getParentFile().getParentFile();
                    classesFolder = new File(buildFolder, "classes");
                }
                if ((outFolder = new File(classesFolder, variantName.replace('-', File.separatorChar))).exists() && (vOutFolder = LocalFileSystem.getInstance().findFileByIoFile(outFolder)) != null && (localClass = this.loadClassFromClassPath(name, VfsUtilCore.virtualToIoFile((VirtualFile)vOutFolder))) != null) {
                    return localClass;
                }
            }
            return null;
        }
        return this.loadClassFromClassPath(name, VfsUtilCore.virtualToIoFile((VirtualFile)vOutFolder));
    }

    @Override
    protected URL[] getExternalJars() {
        ArrayList<URL> result = new ArrayList<URL>();
        for (VirtualFile libFile : AndroidRootUtil.getExternalLibraries(this.myModule)) {
            File file;
            if (!"jar".equals(libFile.getExtension()) || !(file = new File(libFile.getPath())).exists()) continue;
            try {
                result.add(SdkUtils.fileToUrl((File)file));
                File parentFile = file.getParentFile();
                if (parentFile == null || !parentFile.getPath().endsWith(".aar") && !parentFile.getPath().contains("exploded-aar")) continue;
                AarResourceClassRegistry.get().addLibrary(AppResourceRepository.getAppResources(this.myModule, true), parentFile);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        return result.toArray(new URL[result.size()]);
    }
}

