/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.annotations.NonNull;
import com.android.ide.common.resources.FrameworkResources;
import com.android.ide.common.resources.ResourceDeltaKind;
import com.android.ide.common.resources.ResourceFolder;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ScanningContext;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.IAbstractResource;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.rendering.LogWrapper;
import com.android.utils.ILogger;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.BufferingFolderWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkResourceLoader {
    private static final Logger LOG = Logger.getInstance(FrameworkResourceLoader.class);
    private static boolean ourNeedLocales;

    private FrameworkResourceLoader() {
    }

    @Nullable
    public static FrameworkResources load(@NotNull IAndroidTarget myTarget) throws IOException {
        if (myTarget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/FrameworkResourceLoader", "load"));
        }
        LogWrapper logger = new LogWrapper(LOG);
        File resFolder = myTarget.getFile(11);
        if (!resFolder.isDirectory()) {
            LOG.error(AndroidBundle.message("android.directory.cannot.be.found.error", resFolder.getPath()));
            return null;
        }
        return FrameworkResourceLoader.loadPlatformResources(resFolder, logger);
    }

    private static FrameworkResources loadPlatformResources(File resFolder, ILogger log) throws IOException {
        BufferingFolderWrapper resFolderWrapper = new BufferingFolderWrapper(resFolder);
        IdeFrameworkResources resources = new IdeFrameworkResources((IAbstractFolder)resFolderWrapper);
        resources.ensureInitialized();
        resources.loadPublicResources(log);
        return resources;
    }

    public static void requestLocales(boolean needLocales) {
        ourNeedLocales = needLocales;
    }

    public static class IdeFrameworkResources
    extends FrameworkResources {
        private boolean mySkippedLocales;
        private boolean myCleared = true;
        private boolean myInitializing = false;

        public IdeFrameworkResources(@NonNull IAbstractFolder resFolder) {
            super(resFolder);
        }

        public synchronized void clear() {
            super.clear();
            this.myCleared = true;
        }

        public synchronized boolean getSkippedLocales() {
            return this.mySkippedLocales;
        }

        public synchronized boolean ensureInitialized() {
            if (this.myCleared && !this.myInitializing) {
                IAbstractResource[] resources;
                this.mySkippedLocales = !ourNeedLocales;
                ScanningContext context = new ScanningContext((ResourceRepository)this);
                this.myInitializing = true;
                for (IAbstractResource res : resources = this.getResFolder().listMembers()) {
                    IAbstractResource[] files;
                    ResourceFolder resFolder;
                    FolderConfiguration config;
                    IAbstractFolder folder;
                    String resFolderName;
                    if (!(res instanceof IAbstractFolder) || (resFolderName = (folder = (IAbstractFolder)res).getName()).startsWith("values-mcc") || resFolderName.startsWith("raw-") || this.mySkippedLocales && resFolderName.startsWith("values-") && ((config = FolderConfiguration.getConfigForFolder((String)resFolderName)) == null || config.getLanguageQualifier() != null) || (resFolder = this.processFolder(folder)) == null) continue;
                    for (IAbstractResource fileRes : files = folder.listMembers()) {
                        if (!(fileRes instanceof IAbstractFile)) continue;
                        IAbstractFile file = (IAbstractFile)fileRes;
                        resFolder.processFile(file, ResourceDeltaKind.ADDED, context);
                    }
                }
                this.myInitializing = false;
                this.myCleared = false;
                return true;
            }
            return false;
        }
    }
}

