/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkNotConfiguredNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.sdk.not.configured.notification");
    private final Project myProject;
    private final EditorNotifications myNotifications;

    public AndroidSdkNotConfiguredNotificationProvider(Project project, EditorNotifications notifications) {
        this.myProject = project;
        this.myNotifications = notifications;
    }

    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(VirtualFile file, FileEditor fileEditor) {
        AndroidPlatform platform;
        AndroidFacet facet;
        if (file.getFileType() != XmlFileType.INSTANCE) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
        AndroidFacet androidFacet = facet = module != null ? AndroidFacet.getInstance(module) : null;
        if (facet == null) {
            return null;
        }
        if (!facet.isGradleProject() && (AndroidSdkNotConfiguredNotificationProvider.isResourceFile(file, facet) || file.equals(AndroidRootUtil.getPrimaryManifestFile(facet))) && (platform = AndroidPlatform.getInstance(module)) == null) {
            return new MySdkNotConfiguredNotificationPanel(module);
        }
        return null;
    }

    private static boolean isResourceFile(VirtualFile file, AndroidFacet facet) {
        VirtualFile parent = file.getParent();
        VirtualFile resDir = parent != null ? parent.getParent() : null;
        return resDir != null && facet.getLocalResourceManager().isResourceDir(resDir);
    }

    private class MySdkNotConfiguredNotificationPanel
    extends EditorNotificationPanel {
        MySdkNotConfiguredNotificationPanel(final Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkNotConfiguredNotificationProvider$MySdkNotConfiguredNotificationPanel", "<init>"));
            }
            this.setText("Android SDK is not configured for module '" + module.getName() + "' or corrupted");
            this.createActionLabel("Open Project Structure", new Runnable(){

                @Override
                public void run() {
                    ModulesConfigurator.showDialog((Project)module.getProject(), (String)module.getName(), (String)ClasspathEditor.NAME);
                    AndroidSdkNotConfiguredNotificationProvider.this.myNotifications.updateAllNotifications();
                }
            });
        }
    }
}

