/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.SdkConstants;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Log;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.repository.updater.SettingsController;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.sdklib.repository.remote.RemoteSdk;
import com.android.tools.idea.sdk.DefaultSdks;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.collect.Lists;
import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.actions.AndroidEnableAdbServiceAction;
import org.jetbrains.android.logcat.AdbErrors;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkData {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.sdk.AndroidSdkData");
    private static volatile boolean myDdmLibInitialized = false;
    private static volatile boolean myAdbCrashed = false;
    private static final Object myDdmsLock = new Object();
    private static volatile boolean ourDdmLibTerminated = false;
    private final Map<IAndroidTarget, SoftReference<AndroidTargetData>> myTargetDatas;
    private final LocalSdk myLocalSdk;
    private final RemoteSdk myRemoteSdk;
    private final SettingsController mySettingsController;
    private final DeviceManager myDeviceManager;
    private final int myPlatformToolsRevision;
    private final int mySdkToolsRevision;
    private static final List<SoftReference<AndroidSdkData>> mInstances = Lists.newArrayList();

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull File sdkLocation) {
        if (sdkLocation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "getSdkData"));
        }
        return AndroidSdkData.getSdkData(sdkLocation, false);
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull File sdkLocation, boolean forceReparse) {
        AndroidSdkData sdkData;
        if (sdkLocation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "getSdkData"));
        }
        File canonicalLocation = new File(FileUtil.toCanonicalPath((String)sdkLocation.getPath()));
        if (!forceReparse) {
            Iterator<SoftReference<AndroidSdkData>> it = mInstances.iterator();
            while (it.hasNext()) {
                sdkData = (AndroidSdkData)it.next().get();
                if (sdkData == null) {
                    it.remove();
                    continue;
                }
                if (!FileUtil.filesEqual((File)sdkData.getLocation(), (File)canonicalLocation)) continue;
                return sdkData;
            }
        }
        if (!DefaultSdks.isValidAndroidSdkPath(canonicalLocation)) {
            return null;
        }
        LocalSdk localSdk = new LocalSdk(canonicalLocation);
        sdkData = new AndroidSdkData(localSdk);
        mInstances.add(0, (SoftReference<AndroidSdkData>)new SoftReference((Object)sdkData));
        return (AndroidSdkData)mInstances.get(0).get();
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull String sdkPath) {
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "getSdkData"));
        }
        File file = new File(FileUtil.toSystemDependentName((String)sdkPath));
        return AndroidSdkData.getSdkData(file);
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "getSdkData"));
        }
        String sdkHomePath = sdk.getHomePath();
        if (sdkHomePath != null) {
            return AndroidSdkData.getSdkData(sdk.getHomePath());
        }
        return null;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "getSdkData"));
        }
        Sdk sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (sdk != null) {
            return AndroidSdkData.getSdkData(sdk);
        }
        return null;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "getSdkData"));
        }
        return AndroidSdkData.getSdkData(module.getProject());
    }

    private AndroidSdkData(@NotNull LocalSdk localSdk) {
        if (localSdk == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "<init>"));
        }
        this.myTargetDatas = new HashMap();
        this.myLocalSdk = localSdk;
        this.mySettingsController = new SettingsController((ILogger)new NullLogger());
        this.myRemoteSdk = new RemoteSdk(this.mySettingsController);
        this.myPlatformToolsRevision = AndroidCommonUtils.parsePackageRevision((String)localSdk.getPath(), (String)"platform-tools");
        this.mySdkToolsRevision = AndroidCommonUtils.parsePackageRevision((String)localSdk.getPath(), (String)"tools");
        this.myDeviceManager = DeviceManager.createInstance((File)localSdk.getLocation(), (ILogger)new MessageBuildingSdkLog());
    }

    @NotNull
    public File getLocation() {
        File location = this.myLocalSdk.getLocation();
        assert (location != null);
        File file = location;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getLocation"));
        }
        return file;
    }

    @Deprecated
    @NotNull
    public String getPath() {
        String string = this.getLocation().getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getPath"));
        }
        return string;
    }

    @Nullable
    public BuildToolInfo getLatestBuildTool() {
        return this.myLocalSdk.getLatestBuildTool();
    }

    @NotNull
    public IAndroidTarget[] getTargets() {
        IAndroidTarget[] iAndroidTargetArray = this.myLocalSdk.getTargets();
        if (iAndroidTargetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getTargets"));
        }
        return iAndroidTargetArray;
    }

    @Nullable
    public IAndroidTarget findTargetByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "findTargetByName"));
        }
        for (IAndroidTarget target : this.getTargets()) {
            if (!target.getName().equals(name)) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public IAndroidTarget findTargetByApiLevel(@NotNull String apiLevel) {
        if (apiLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "findTargetByApiLevel"));
        }
        IAndroidTarget candidate = null;
        for (IAndroidTarget target : this.getTargets()) {
            if (!AndroidSdkUtils.targetHasId(target, apiLevel)) continue;
            if (target.isPlatform()) {
                return target;
            }
            if (candidate != null) continue;
            candidate = target;
        }
        return candidate;
    }

    @Nullable
    public IAndroidTarget findTargetByHashString(@NotNull String hashString) {
        if (hashString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "findTargetByHashString"));
        }
        return this.myLocalSdk.getTargetFromHashString(hashString);
    }

    public int getPlatformToolsRevision() {
        return this.myPlatformToolsRevision;
    }

    public int getSdkToolsRevision() {
        return this.mySdkToolsRevision;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AndroidSdkData sdkData = (AndroidSdkData)obj;
        return FileUtil.filesEqual((File)this.getLocation(), (File)sdkData.getLocation());
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    private boolean initializeDdmlib(@NotNull Project project) {
        boolean retryWas;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "initializeDdmlib"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        do {
            final MyInitializeDdmlibTask task = new MyInitializeDdmlibTask(project);
            AdbErrors.clear();
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    AndroidSdkData.this.doInitializeDdmlib();
                    task.finish();
                }
            });
            t.start();
            retryWas = false;
            while (!task.isFinished()) {
                ProgressManager.getInstance().run((Task)task);
                boolean finished = task.isFinished();
                if (task.isCanceled()) {
                    myAdbCrashed = !finished;
                    AndroidSdkData.forceInterrupt(t);
                    return false;
                }
                myAdbCrashed = false;
                if (finished) continue;
                String adbErrorString = AndroidSdkData.combine(AdbErrors.getErrors());
                int result = Messages.showDialog((Project)project, (String)("ADB not responding. You can wait more, or kill \"" + SdkConstants.FN_ADB + "\" process manually and click 'Restart'" + (adbErrorString.length() > 0 ? "\nErrors from ADB:\n" + adbErrorString : "")), (String)CommonBundle.getErrorTitle(), (String[])new String[]{"&Wait more", "&Restart", "&Cancel"}, (int)0, (Icon)Messages.getErrorIcon());
                if (result == 2) {
                    myAdbCrashed = true;
                    AndroidSdkData.forceInterrupt(t);
                    return false;
                }
                if (result != 1) continue;
                myAdbCrashed = true;
                retryWas = true;
            }
        } while (retryWas);
        return true;
    }

    @NotNull
    private static String combine(@NotNull String[] strs) {
        if (strs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "combine"));
        }
        StringBuilder builder = new StringBuilder();
        for (String str : strs) {
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(str);
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "combine"));
        }
        return string;
    }

    private static void forceInterrupt(Thread thread) {
        for (int i = 0; i < 6 && thread.isAlive(); ++i) {
            thread.interrupt();
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void doInitializeDdmlib() {
        AndroidSdkData.doInitializeDdmlib(this.getAdbPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doInitializeDdmlib(@NotNull String adbPath) {
        if (adbPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "doInitializeDdmlib"));
        }
        Object object = myDdmsLock;
        synchronized (object) {
            if (!myDdmLibInitialized) {
                myDdmLibInitialized = true;
                ourDdmLibTerminated = false;
                DdmPreferences.setLogLevel((String)Log.LogLevel.INFO.getStringValue());
                DdmPreferences.setTimeOut((int)3000000);
                AndroidDebugBridge.init((boolean)AndroidEnableAdbServiceAction.isAdbServiceEnabled());
                LOG.info("DDMLib initialized");
                AndroidDebugBridge bridge = AndroidDebugBridge.createBridge((String)adbPath, (boolean)true);
                AndroidSdkData.waitUntilConnect(bridge);
                if (!bridge.isConnected()) {
                    LOG.info("Failed to connect debug bridge");
                }
            } else {
                boolean forceRestart;
                AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
                boolean bl = forceRestart = myAdbCrashed || bridge != null && !bridge.isConnected();
                if (forceRestart) {
                    LOG.info("Restart debug bridge: " + (myAdbCrashed ? "crashed" : "disconnected"));
                }
                AndroidDebugBridge newBridge = AndroidDebugBridge.createBridge((String)adbPath, (boolean)forceRestart);
                AndroidSdkData.waitUntilConnect(newBridge);
                if (!newBridge.isConnected()) {
                    LOG.info("Failed to connect debug bridge after restart");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitUntilConnect(@NotNull AndroidDebugBridge bridge) {
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "waitUntilConnect"));
        }
        while (!(bridge.isConnected() || Thread.currentThread().isInterrupted() || ourDdmLibTerminated)) {
            Object object = myDdmsLock;
            synchronized (object) {
                try {
                    myDdmsLock.wait(1000L);
                }
                catch (InterruptedException e) {
                    LOG.debug((Throwable)e);
                    return;
                }
            }
        }
    }

    private String getAdbPath() {
        String path = this.getLocation() + File.separator + SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + SdkConstants.FN_ADB;
        if (!new File(path).exists()) {
            path = this.getLocation() + File.separator + AndroidCommonUtils.toolPath((String)SdkConstants.FN_ADB);
        }
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminateDdmlib() {
        Object object = myDdmsLock;
        synchronized (object) {
            ourDdmLibTerminated = true;
            myDdmsLock.notifyAll();
            AndroidDebugBridge.disconnectBridge();
            AndroidDebugBridge.terminate();
            LOG.info("DDMLib terminated");
            myDdmLibInitialized = false;
        }
    }

    @Nullable
    public AndroidDebugBridge getDebugBridge(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "getDebugBridge"));
        }
        if (!this.initializeDdmlib(project)) {
            return null;
        }
        return AndroidDebugBridge.getBridge();
    }

    @NotNull
    public LocalSdk getLocalSdk() {
        LocalSdk localSdk = this.myLocalSdk;
        if (localSdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getLocalSdk"));
        }
        return localSdk;
    }

    @NotNull
    public RemoteSdk getRemoteSdk() {
        RemoteSdk remoteSdk = this.myRemoteSdk;
        if (remoteSdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getRemoteSdk"));
        }
        return remoteSdk;
    }

    @NotNull
    public SettingsController getSettingsController() {
        SettingsController settingsController = this.mySettingsController;
        if (settingsController == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getSettingsController"));
        }
        return settingsController;
    }

    @NotNull
    public DeviceManager getDeviceManager() {
        DeviceManager deviceManager = this.myDeviceManager;
        if (deviceManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getDeviceManager"));
        }
        return deviceManager;
    }

    @NotNull
    public AndroidTargetData getTargetData(@NotNull IAndroidTarget target) {
        AndroidTargetData targetData;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData", "getTargetData"));
        }
        SoftReference<AndroidTargetData> targetDataRef = this.myTargetDatas.get(target);
        AndroidTargetData androidTargetData = targetData = targetDataRef != null ? (AndroidTargetData)targetDataRef.get() : null;
        if (targetData == null) {
            targetData = new AndroidTargetData(this, target);
            this.myTargetDatas.put(target, (SoftReference<AndroidTargetData>)new SoftReference((Object)targetData));
        }
        AndroidTargetData androidTargetData2 = targetData;
        if (androidTargetData2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getTargetData"));
        }
        return androidTargetData2;
    }

    private static class MyInitializeDdmlibTask
    extends Task.Modal {
        private final Object myLock = new Object();
        private volatile boolean myFinished;
        private volatile boolean myCanceled;

        public MyInitializeDdmlibTask(Project project) {
            super(project, "Waiting for ADB", true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFinished() {
            Object object = this.myLock;
            synchronized (object) {
                return this.myFinished;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCanceled() {
            Object object = this.myLock;
            synchronized (object) {
                return this.myCanceled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            Object object = this.myLock;
            synchronized (object) {
                this.myFinished = true;
                this.myLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCancel() {
            Object object = this.myLock;
            synchronized (object) {
                this.myCanceled = true;
                this.myLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/sdk/AndroidSdkData$MyInitializeDdmlibTask", "run"));
            }
            indicator.setIndeterminate(true);
            Object object = this.myLock;
            synchronized (object) {
                long wastedTime;
                long startTime = System.currentTimeMillis();
                long timeout = 10000L;
                while (!(this.myFinished || this.myCanceled || indicator.isCanceled() || (wastedTime = System.currentTimeMillis() - startTime) >= 10000L)) {
                    try {
                        this.myLock.wait(Math.min(10000L - wastedTime, 500L));
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }
    }
}

