/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.IAndroidTarget;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.AndroidRunningState;
import org.jetbrains.android.run.AvdComboBox;
import org.jetbrains.android.run.DeviceChooser;
import org.jetbrains.android.run.DeviceChooserListener;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedDeviceChooserDialog
extends DialogWrapper {
    private final Project myProject;
    private final DeviceChooser myDeviceChooser;
    private JPanel myPanel;
    private JRadioButton myChooserRunningDeviceRadioButton;
    private JPanel myDeviceChooserWrapper;
    private JRadioButton myLaunchEmulatorRadioButton;
    private JPanel myComboBoxWrapper;
    private JLabel myAvdLabel;
    private JCheckBox myReuseSelectionCheckbox;
    private final AvdComboBox myAvdCombo;
    @NonNls
    private static final String SELECTED_SERIALS_PROPERTY = "ANDROID_EXTENDED_DEVICE_CHOOSER_SERIALS";
    @NonNls
    private static final String SELECTED_AVD_PROPERTY = "ANDROID_EXTENDED_DEVICE_CHOOSER_AVD";

    public ExtendedDeviceChooserDialog(final @NotNull AndroidFacet facet, @NotNull IAndroidTarget projectTarget, boolean multipleSelection, boolean showReuseDevicesCheckbox, boolean selectReuseDevicesCheckbox) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/ExtendedDeviceChooserDialog", "<init>"));
        }
        if (projectTarget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/run/ExtendedDeviceChooserDialog", "<init>"));
        }
        super(facet.getModule().getProject(), true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(AndroidBundle.message("choose.device.dialog.title", objectArray));
        this.myProject = facet.getModule().getProject();
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        String serialsStr = properties.getValue(SELECTED_SERIALS_PROPERTY);
        String[] selectedSerials = serialsStr != null ? serialsStr.split(" ") : null;
        this.getOKAction().setEnabled(false);
        this.myDeviceChooser = new DeviceChooser(multipleSelection, this.getOKAction(), facet, projectTarget, null);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myDeviceChooser);
        this.myDeviceChooser.addListener(new DeviceChooserListener(){

            @Override
            public void selectedDevicesChanged() {
                ExtendedDeviceChooserDialog.this.updateOkButton();
            }
        });
        this.myAvdCombo = new AvdComboBox(false, true){

            @Override
            public Module getModule() {
                return facet.getModule();
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myAvdCombo);
        this.myAvdCombo.getComboBox().setRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    this.append(AndroidBundle.message("android.ddms.nodevices", new Object[0]), ExtendedDeviceChooserDialog.this.myAvdCombo.getComboBox().isEnabled() ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else {
                    this.append(value.toString());
                }
            }
        });
        this.myComboBoxWrapper.add((Component)((Object)this.myAvdCombo));
        this.myAvdLabel.setLabelFor((Component)((Object)this.myAvdCombo));
        this.myDeviceChooserWrapper.add(this.myDeviceChooser.getPanel());
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendedDeviceChooserDialog.this.updateEnabled();
            }
        };
        this.myLaunchEmulatorRadioButton.addActionListener(listener);
        this.myChooserRunningDeviceRadioButton.addActionListener(listener);
        this.myAvdCombo.getComboBox().addActionListener(listener);
        this.init();
        this.myDeviceChooser.init(selectedSerials);
        this.myLaunchEmulatorRadioButton.setSelected(!this.myDeviceChooser.hasDevices());
        this.myChooserRunningDeviceRadioButton.setSelected(this.myDeviceChooser.hasDevices());
        this.myAvdCombo.startUpdatingAvds(ModalityState.stateForComponent((Component)this.myPanel));
        String savedAvd = properties.getValue(SELECTED_AVD_PROPERTY);
        String avdToSelect = null;
        if (savedAvd != null) {
            ComboBoxModel model = this.myAvdCombo.getComboBox().getModel();
            int n = model.getSize();
            for (int i = 0; i < n; ++i) {
                String item = (String)model.getElementAt(i);
                if (!savedAvd.equals(item)) continue;
                avdToSelect = item;
                break;
            }
        }
        if (avdToSelect != null) {
            this.myAvdCombo.getComboBox().setSelectedItem(avdToSelect);
        } else if (this.myAvdCombo.getComboBox().getModel().getSize() > 0) {
            this.myAvdCombo.getComboBox().setSelectedIndex(0);
        }
        this.myReuseSelectionCheckbox.setVisible(showReuseDevicesCheckbox);
        this.myReuseSelectionCheckbox.setSelected(selectReuseDevicesCheckbox);
        this.updateEnabled();
    }

    private void updateOkButton() {
        if (this.myLaunchEmulatorRadioButton.isSelected()) {
            this.getOKAction().setEnabled(this.getSelectedAvd() != null);
        } else {
            this.getOKAction().setEnabled(this.getSelectedDevices().length > 0);
        }
    }

    private void updateEnabled() {
        this.myAvdCombo.setEnabled(this.myLaunchEmulatorRadioButton.isSelected());
        this.myAvdLabel.setEnabled(this.myLaunchEmulatorRadioButton.isSelected());
        this.myDeviceChooser.setEnabled(this.myChooserRunningDeviceRadioButton.isSelected());
        this.updateOkButton();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDeviceChooser.getPreferredFocusComponent();
    }

    protected void doOKAction() {
        this.myDeviceChooser.finish();
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        properties.setValue(SELECTED_SERIALS_PROPERTY, AndroidRunningState.toString(this.myDeviceChooser.getSelectedDevices()));
        String selectedAvd = (String)this.myAvdCombo.getComboBox().getSelectedItem();
        if (selectedAvd != null) {
            properties.setValue(SELECTED_AVD_PROPERTY, selectedAvd);
        } else {
            properties.unsetValue(SELECTED_AVD_PROPERTY);
        }
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "AndroidExtendedDeviceChooserDialog";
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NotNull
    public IDevice[] getSelectedDevices() {
        IDevice[] iDeviceArray = this.myDeviceChooser.getSelectedDevices();
        if (iDeviceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/ExtendedDeviceChooserDialog", "getSelectedDevices"));
        }
        return iDeviceArray;
    }

    @Nullable
    public String getSelectedAvd() {
        return (String)this.myAvdCombo.getComboBox().getSelectedItem();
    }

    public boolean isToLaunchEmulator() {
        return this.myLaunchEmulatorRadioButton.isSelected();
    }

    public boolean useSameDevicesAgain() {
        return this.myReuseSelectionCheckbox.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JPanel jPanel2;
        JRadioButton jRadioButton2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myChooserRunningDeviceRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.extended.device.chooser.running.device.radio"));
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myDeviceChooserWrapper = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myLaunchEmulatorRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.extended.device.chooser.launch.emulator.radio"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAvdLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.extended.device.chooser.avd.label"));
        jPanel3.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myComboBoxWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myReuseSelectionCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use same device for future launches");
        jPanel3.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

