/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import org.jetbrains.android.actions.RunAndroidAvdManagerAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.util.ComponentBasedErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AvdComboBox
extends ComboboxWithBrowseButton {
    private final boolean myAddEmptyElement;
    private final boolean myShowNotLaunchedOnly;
    private final Alarm myAlarm = new Alarm((Disposable)this);
    private String[] myOldAvds = ArrayUtil.EMPTY_STRING_ARRAY;

    public AvdComboBox(boolean addEmptyElement, boolean showNotLaunchedOnly) {
        this.myAddEmptyElement = addEmptyElement;
        this.myShowNotLaunchedOnly = showNotLaunchedOnly;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidPlatform platform = AvdComboBox.this.findAndroidPlatform();
                if (platform == null) {
                    Messages.showErrorDialog((Component)((Object)AvdComboBox.this), (String)"Cannot find any configured Android SDK");
                    return;
                }
                RunAndroidAvdManagerAction.runAvdManager(platform.getSdkData().getPath(), new ComponentBasedErrorReporter((JComponent)((Object)AvdComboBox.this)), ModalityState.stateForComponent((Component)((Object)AvdComboBox.this)));
            }
        });
        this.setMinimumSize(new Dimension(100, this.getMinimumSize().height));
    }

    public void startUpdatingAvds(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AvdComboBox", "startUpdatingAvds"));
        }
        if (!this.getComboBox().isPopupVisible()) {
            this.doUpdateAvds();
        }
        this.addUpdatingRequest(modalityState);
    }

    private void addUpdatingRequest(final @NotNull ModalityState modalityState) {
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AvdComboBox", "addUpdatingRequest"));
        }
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                AvdComboBox.this.startUpdatingAvds(modalityState);
            }
        }, 500, modalityState);
    }

    public void dispose() {
        this.myAlarm.cancelAllRequests();
        super.dispose();
    }

    private void doUpdateAvds() {
        Object[] newAvds;
        Module module = this.getModule();
        if (module == null || module.isDisposed()) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            String avdName;
            AndroidDebugBridge debugBridge;
            HashSet filteringSet = new HashSet();
            if (this.myShowNotLaunchedOnly && (debugBridge = facet.getDebugBridge()) != null) {
                for (IDevice iDevice : debugBridge.getDevices()) {
                    avdName = iDevice.getAvdName();
                    if (avdName == null || avdName.length() <= 0) continue;
                    filteringSet.add(avdName);
                }
            }
            ArrayList<String> newAvdList = new ArrayList<String>();
            if (this.myAddEmptyElement) {
                newAvdList.add("");
            }
            for (IDevice iDevice : facet.getAllAvds()) {
                avdName = iDevice.getName();
                if (filteringSet.contains(avdName)) continue;
                newAvdList.add(avdName);
            }
            newAvds = ArrayUtil.toStringArray(newAvdList);
        } else {
            newAvds = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (!Arrays.equals(this.myOldAvds, newAvds)) {
            this.myOldAvds = newAvds;
            Object selected = this.getComboBox().getSelectedItem();
            this.getComboBox().setModel(new DefaultComboBoxModel<Object>(newAvds));
            this.getComboBox().setSelectedItem(selected);
        }
    }

    @Nullable
    public abstract Module getModule();

    @Nullable
    private AndroidPlatform findAndroidPlatform() {
        AndroidPlatform platform = this.findAndroidPlatformFromModule();
        if (platform != null) {
            return platform;
        }
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            SdkAdditionalData data;
            if (!(sdk.getSdkType() instanceof AndroidSdkType) || !((data = sdk.getSdkAdditionalData()) instanceof AndroidSdkAdditionalData) || (platform = ((AndroidSdkAdditionalData)data).getAndroidPlatform()) == null) continue;
            return platform;
        }
        return null;
    }

    @Nullable
    private AndroidPlatform findAndroidPlatformFromModule() {
        Module module = this.getModule();
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        return ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
    }
}

