/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.annotations.Nullable;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.options.CompileStepBeforeRunNoErrorCheck;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactType;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.run.AndroidRunConfiguration;
import org.jetbrains.android.run.ConfigurationSpecificEditor;
import org.jetbrains.android.util.AndroidBundle;

class ApplicationRunParameters
implements ConfigurationSpecificEditor<AndroidRunConfiguration> {
    public static final Key<ApplicationRunParameters> ACTIVITY_CLASS_TEXT_FIELD_KEY = Key.create((String)"ActivityClassTextField");
    private ComponentWithBrowseButton<EditorTextField> myActivityField;
    private JRadioButton myLaunchDefaultButton;
    private JRadioButton myLaunchCustomButton;
    private JPanel myPanel;
    private JRadioButton myDoNothingButton;
    private JBRadioButton myDeployDefaultApkRadio;
    private JBRadioButton myDeployArtifactRadio;
    private JBRadioButton myDoNotDeployRadio;
    private ComboBox myArtifactCombo;
    private final Project myProject;
    private final ConfigurationModuleSelector myModuleSelector;
    private Artifact myLastSelectedArtifact;

    ApplicationRunParameters(final Project project, final ConfigurationModuleSelector moduleSelector) {
        this.myProject = project;
        this.myModuleSelector = moduleSelector;
        this.$$$setupUI$$$();
        this.myActivityField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!project.isInitialized()) {
                    return;
                }
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                PsiClass activityBaseClass = facade.findClass("android.app.Activity", ProjectScope.getAllScope((Project)project));
                if (activityBaseClass == null) {
                    Messages.showErrorDialog((Component)ApplicationRunParameters.this.myPanel, (String)AndroidBundle.message("cant.find.activity.class.error", new Object[0]));
                    return;
                }
                Module module = moduleSelector.getModule();
                if (module == null) {
                    Messages.showErrorDialog((Component)ApplicationRunParameters.this.myPanel, (String)ExecutionBundle.message((String)"module.not.specified.error.text", (Object[])new Object[0]));
                    return;
                }
                PsiClass initialSelection = facade.findClass(((EditorTextField)ApplicationRunParameters.this.myActivityField.getChildComponent()).getText(), module.getModuleWithDependenciesScope());
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createInheritanceClassChooser("Select Activity Class", module.getModuleWithDependenciesScope(), activityBaseClass, initialSelection, null);
                chooser.showDialog();
                PsiClass selClass = chooser.getSelected();
                if (selClass != null) {
                    ((EditorTextField)ApplicationRunParameters.this.myActivityField.getChildComponent()).setText(selClass.getQualifiedName());
                }
            }
        });
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationRunParameters.this.myActivityField.setEnabled(ApplicationRunParameters.this.myLaunchCustomButton.isSelected());
            }
        };
        this.myLaunchCustomButton.addActionListener(listener);
        this.myLaunchDefaultButton.addActionListener(listener);
        this.myDoNothingButton.addActionListener(listener);
        ActionListener listener1 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationRunParameters.this.myArtifactCombo.setEnabled(ApplicationRunParameters.this.myDeployArtifactRadio.isSelected());
                ApplicationRunParameters.this.updateBuildArtifactBeforeRunSetting();
            }
        };
        this.myDeployDefaultApkRadio.addActionListener(listener1);
        this.myDoNotDeployRadio.addActionListener(listener1);
        this.myDeployArtifactRadio.addActionListener(listener1);
        this.myArtifactCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationRunParameters.this.updateBuildArtifactBeforeRunSetting();
            }
        });
    }

    private void updateBuildArtifactBeforeRunSetting() {
        Object item;
        Artifact newArtifact = null;
        if (this.myDeployArtifactRadio.isSelected() && (item = this.myArtifactCombo.getSelectedItem()) instanceof Artifact) {
            newArtifact = (Artifact)item;
        }
        if (Comparing.equal(newArtifact, (Object)this.myLastSelectedArtifact)) {
            return;
        }
        if (this.myLastSelectedArtifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption((JComponent)this.myPanel, (Project)this.myProject, (Artifact)this.myLastSelectedArtifact, (boolean)false);
        }
        if (newArtifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption((JComponent)this.myPanel, (Project)this.myProject, (Artifact)newArtifact, (boolean)true);
        }
        if (this.myLastSelectedArtifact == null || newArtifact == null) {
            this.addOrRemoveMakeTask(newArtifact == null);
        }
        this.myLastSelectedArtifact = newArtifact;
    }

    private void addOrRemoveMakeTask(boolean add) {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myPanel);
        ConfigurationSettingsEditorWrapper editor = (ConfigurationSettingsEditorWrapper)ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.getData(dataContext);
        if (editor == null) {
            return;
        }
        ArrayList<BeforeRunTask> makeTasks = new ArrayList<BeforeRunTask>();
        for (BeforeRunTask task : editor.getStepsBeforeLaunch()) {
            if (!(task instanceof CompileStepBeforeRun.MakeBeforeRunTask) && !(task instanceof CompileStepBeforeRunNoErrorCheck.MakeBeforeRunTaskNoErrorCheck)) continue;
            makeTasks.add(task);
        }
        if (add) {
            if (makeTasks.size() == 0) {
                editor.addBeforeLaunchStep((BeforeRunTask)new CompileStepBeforeRun.MakeBeforeRunTask());
            } else {
                for (BeforeRunTask task : makeTasks) {
                    task.setEnabled(true);
                }
            }
        } else {
            for (BeforeRunTask task : makeTasks) {
                task.setEnabled(false);
            }
        }
    }

    @Nullable
    public Module getModule() {
        return this.myModuleSelector.getModule();
    }

    @Override
    public void resetFrom(AndroidRunConfiguration configuration) {
        boolean launchSpecificActivity = configuration.MODE.equals("specific_activity");
        if (configuration.MODE.equals("default_activity")) {
            this.myLaunchDefaultButton.setSelected(true);
        } else if (launchSpecificActivity) {
            this.myLaunchCustomButton.setSelected(true);
        } else {
            this.myDoNothingButton.setSelected(true);
        }
        this.myActivityField.setEnabled(launchSpecificActivity);
        ((EditorTextField)this.myActivityField.getChildComponent()).setText(configuration.ACTIVITY_CLASS);
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.myProject);
        List<Artifact> artifacts = artifactManager == null ? Collections.emptyList() : artifactManager.getArtifactsByType(AndroidApplicationArtifactType.getInstance());
        String artifactName = configuration.ARTIFACT_NAME;
        Artifact artifactToSelect = null;
        if (configuration.DEPLOY) {
            this.myDoNotDeployRadio.setSelected(false);
            if (!StringUtil.isEmpty((String)artifactName)) {
                Module module = this.getModule();
                for (Artifact artifact : artifacts) {
                    if (!artifactName.equals(artifact.getName()) || !AndroidArtifactUtil.isRelatedArtifact(artifact, module)) continue;
                    artifactToSelect = artifact;
                    break;
                }
                this.myDeployArtifactRadio.setSelected(true);
                this.myDeployDefaultApkRadio.setSelected(false);
            } else {
                this.myDeployArtifactRadio.setSelected(false);
                this.myDeployDefaultApkRadio.setSelected(true);
            }
        } else {
            this.myDeployArtifactRadio.setSelected(false);
            this.myDeployDefaultApkRadio.setSelected(false);
            this.myDoNotDeployRadio.setSelected(true);
        }
        this.myArtifactCombo.setEnabled(this.myDeployArtifactRadio.isSelected());
        if (artifactToSelect != null || artifactName.length() == 0) {
            this.myArtifactCombo.setModel(new DefaultComboBoxModel<Object>(artifacts.toArray()));
            if (artifactToSelect != null) {
                this.myArtifactCombo.setSelectedItem((Object)artifactToSelect);
            }
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(artifactName);
            list.addAll(Arrays.asList(artifacts));
            this.myArtifactCombo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
            this.myArtifactCombo.setSelectedItem((Object)artifactName);
        }
        this.myArtifactCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof Artifact) {
                    Artifact artifact = (Artifact)value;
                    this.setText(artifact.getName());
                    this.setIcon(artifact.getArtifactType().getIcon());
                } else if (value instanceof String) {
                    this.setText("<html><font color='red'>" + value + "</font></html>");
                }
            }
        });
        Object item = this.myDeployArtifactRadio.isSelected() ? this.myArtifactCombo.getSelectedItem() : null;
        this.myLastSelectedArtifact = item instanceof Artifact ? (Artifact)item : null;
    }

    @Override
    public Component getComponent() {
        return this.myPanel;
    }

    @Override
    public void applyTo(AndroidRunConfiguration configuration) {
        configuration.ACTIVITY_CLASS = ((EditorTextField)this.myActivityField.getChildComponent()).getText();
        configuration.MODE = this.myLaunchDefaultButton.isSelected() ? "default_activity" : (this.myLaunchCustomButton.isSelected() ? "specific_activity" : "do_nothing");
        boolean bl = configuration.DEPLOY = !this.myDoNotDeployRadio.isSelected();
        if (this.myDeployArtifactRadio.isSelected()) {
            Object item = this.myArtifactCombo.getSelectedItem();
            if (item instanceof Artifact) {
                Artifact artifact = (Artifact)item;
                configuration.ARTIFACT_NAME = artifact.getName();
            } else {
                configuration.ARTIFACT_NAME = item != null ? item.toString() : "";
            }
        } else {
            configuration.ARTIFACT_NAME = "";
        }
    }

    public JComponent getAnchor() {
        return null;
    }

    public void setAnchor(JComponent anchor) {
    }

    private void createUIComponents() {
        LanguageTextField editorTextField = new LanguageTextField((Language)PlainTextLanguage.INSTANCE, this.myProject, ""){

            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                PsiFile file = PsiDocumentManager.getInstance((Project)ApplicationRunParameters.this.myProject).getPsiFile((Document)editor.getDocument());
                if (file != null) {
                    DaemonCodeAnalyzer.getInstance((Project)ApplicationRunParameters.this.myProject).setHighlightingEnabled(file, false);
                }
                editor.putUserData(ACTIVITY_CLASS_TEXT_FIELD_KEY, (Object)ApplicationRunParameters.this);
                return editor;
            }
        };
        this.myActivityField = new ComponentWithBrowseButton((JComponent)editorTextField, null);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Font font = jPanel2.getFont();
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Activity", (int)0, (int)0, (Font)new Font(font.getName(), font.getStyle(), font.getSize()), (Color)new Color(-16777216)));
        this.myDoNothingButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.do.nothing.label"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myLaunchDefaultButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Launch default Activity");
        jRadioButton2.setMnemonic('L');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myLaunchCustomButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Launch:");
        jRadioButton.setMnemonic('A');
        jRadioButton.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComponentWithBrowseButton<EditorTextField> componentWithBrowseButton = this.myActivityField;
        jPanel2.add((Component)componentWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Package", (int)0, (int)0, null, null));
        this.myDeployDefaultApkRadio = jBRadioButton3 = new JBRadioButton();
        jBRadioButton3.setText("Deploy default APK");
        jPanel3.add((Component)jBRadioButton3, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myDeployArtifactRadio = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("Deploy custom artifact:");
        jPanel3.add((Component)jBRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDoNotDeployRadio = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Do not deploy anything");
        jPanel3.add((Component)jBRadioButton, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myArtifactCombo = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, new Dimension(150, -1), new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton3);
        buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton3);
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

