/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.model.ManifestInfo;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.AndroidApplicationLauncher;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.android.run.AndroidRunConfigurationEditor;
import org.jetbrains.android.run.AndroidRunningState;
import org.jetbrains.android.run.ApplicationRunParameters;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunConfiguration
extends AndroidRunConfigurationBase
implements RefactoringListenerProvider {
    @NonNls
    public static final String LAUNCH_DEFAULT_ACTIVITY = "default_activity";
    @NonNls
    public static final String LAUNCH_SPECIFIC_ACTIVITY = "specific_activity";
    @NonNls
    public static final String DO_NOTHING = "do_nothing";
    public String ACTIVITY_CLASS = "";
    public String MODE = "default_activity";
    public boolean DEPLOY = true;
    public String ARTIFACT_NAME = "";

    public AndroidRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
    }

    @Override
    protected Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidRunConfiguration", "supportsRunningLibraryProjects"));
        }
        return new Pair((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
    }

    @Override
    protected void checkConfiguration(@NotNull AndroidFacet facet) throws RuntimeConfigurationException {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidRunConfiguration", "checkConfiguration"));
        }
        boolean packageContainMavenProperty = AndroidRunConfiguration.doesPackageContainMavenProperty(facet);
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        Module module = facet.getModule();
        if (this.MODE.equals(LAUNCH_SPECIFIC_ACTIVITY)) {
            Project project = configurationModule.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiClass activityClass = facade.findClass("android.app.Activity", ProjectScope.getAllScope((Project)project));
            if (activityClass == null) {
                throw new RuntimeConfigurationError(AndroidBundle.message("cant.find.activity.class.error", new Object[0]));
            }
            if (this.ACTIVITY_CLASS == null || this.ACTIVITY_CLASS.length() == 0) {
                throw new RuntimeConfigurationError(AndroidBundle.message("activity.class.not.specified.error", new Object[0]));
            }
            PsiClass c = configurationModule.findClass(this.ACTIVITY_CLASS);
            if (c == null || !c.isInheritor(activityClass, true)) {
                ActivityAlias activityAlias = AndroidRunConfiguration.findActivityAlias(facet, this.ACTIVITY_CLASS);
                if (activityAlias == null) {
                    throw new RuntimeConfigurationError(AndroidBundle.message("not.activity.subclass.error", this.ACTIVITY_CLASS));
                }
                if (!AndroidRunConfiguration.isActivityLaunchable(activityAlias.getIntentFilters())) {
                    throw new RuntimeConfigurationError(AndroidBundle.message("activity.not.launchable.error", "android.intent.action.MAIN"));
                }
                return;
            }
            if (!packageContainMavenProperty) {
                List<Activity> activities = ManifestInfo.get(module, true).getActivities();
                Activity activity = AndroidDomUtil.getActivityDomElementByClass(activities, c);
                Module libModule = null;
                if (activity == null) {
                    for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(module, true)) {
                        Module depModule = depFacet.getModule();
                        activities = ManifestInfo.get(depModule, true).getActivities();
                        activity = AndroidDomUtil.getActivityDomElementByClass(activities, c);
                        if (activity == null) continue;
                        libModule = depModule;
                        break;
                    }
                    if (activity == null) {
                        throw new RuntimeConfigurationError(AndroidBundle.message("activity.not.declared.in.manifest", c.getName()));
                    }
                    if (!facet.getProperties().ENABLE_MANIFEST_MERGING) {
                        throw new RuntimeConfigurationError(AndroidBundle.message("activity.declared.but.manifest.merging.disabled", c.getName(), libModule.getName(), module.getName()));
                    }
                }
            }
        } else if (this.MODE.equals(LAUNCH_DEFAULT_ACTIVITY)) {
            List<ActivityAlias> activityAliases;
            if (packageContainMavenProperty) {
                return;
            }
            List<Activity> activities = ManifestInfo.get(module, true).getActivities();
            String activity = AndroidUtils.getDefaultLauncherActivityName(activities, activityAliases = ManifestInfo.get(module, true).getActivityAliases());
            if (activity != null) {
                return;
            }
            throw new RuntimeConfigurationError(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
        }
    }

    @Nullable
    private static ActivityAlias findActivityAlias(@NotNull AndroidFacet facet, @NotNull String name) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidRunConfiguration", "findActivityAlias"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/run/AndroidRunConfiguration", "findActivityAlias"));
        }
        ActivityAlias alias = AndroidRunConfiguration.doFindActivityAlias(facet, name);
        if (alias != null) {
            return alias;
        }
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(facet.getModule(), true)) {
            alias = AndroidRunConfiguration.doFindActivityAlias(depFacet, name);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Nullable
    private static ActivityAlias doFindActivityAlias(@NotNull AndroidFacet facet, @NotNull String name) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidRunConfiguration", "doFindActivityAlias"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/run/AndroidRunConfiguration", "doFindActivityAlias"));
        }
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return null;
        }
        Application application = manifest.getApplication();
        if (application == null) {
            return null;
        }
        String aPackage = manifest.getPackage().getStringValue();
        for (ActivityAlias activityAlias : application.getActivityAliass()) {
            String alias = activityAlias.getName().getStringValue();
            if (alias == null || alias.length() <= 0 || !name.endsWith(alias)) continue;
            String prefix = name.substring(0, name.length() - alias.length());
            if (prefix.endsWith(".")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            if (prefix.length() != 0 && !prefix.equals(aPackage)) continue;
            return activityAlias;
        }
        return null;
    }

    private static boolean doesPackageContainMavenProperty(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidRunConfiguration", "doesPackageContainMavenProperty"));
        }
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return false;
        }
        String aPackage = manifest.getPackage().getStringValue();
        return aPackage != null && aPackage.contains("${");
    }

    @Override
    public AndroidRunningState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/run/AndroidRunConfiguration", "getState"));
        }
        AndroidRunningState state = super.getState(executor, env);
        if (state != null) {
            state.setDeploy(this.DEPLOY);
            state.setArtifactName(this.ARTIFACT_NAME);
            state.setOpenLogcatAutomatically(this.SHOW_LOGCAT_AUTOMATICALLY);
            state.setFilterLogcatAutomatically(this.FILTER_LOGCAT_AUTOMATICALLY);
        }
        return state;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        AndroidRunConfigurationEditor<AndroidRunConfiguration> editor = new AndroidRunConfigurationEditor<AndroidRunConfiguration>(project, (Predicate<AndroidFacet>)Predicates.alwaysFalse());
        editor.setConfigurationSpecificEditor(new ApplicationRunParameters(project, editor.getModuleSelector()));
        AndroidRunConfigurationEditor<AndroidRunConfiguration> androidRunConfigurationEditor = editor;
        if (androidRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunConfiguration", "getConfigurationEditor"));
        }
        return androidRunConfigurationEditor;
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return RefactoringListeners.getClassOrPackageListener((PsiElement)element, (RefactoringListeners.Accessor)new RefactoringListeners.Accessor<PsiClass>(){

            public void setName(String qualifiedName) {
                AndroidRunConfiguration.this.ACTIVITY_CLASS = qualifiedName;
            }

            @Nullable
            public PsiClass getPsiElement() {
                return ((JavaRunConfigurationModule)AndroidRunConfiguration.this.getConfigurationModule()).findClass(AndroidRunConfiguration.this.ACTIVITY_CLASS);
            }

            public void setPsiElement(PsiClass psiClass) {
                AndroidRunConfiguration.this.ACTIVITY_CLASS = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass);
            }
        });
    }

    @Override
    @NotNull
    protected ConsoleView attachConsole(AndroidRunningState state, Executor executor) {
        Project project = ((JavaRunConfigurationModule)this.getConfigurationModule()).getProject();
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        ConsoleView console = builder.getConsole();
        console.attachToProcess(state.getProcessHandler());
        ConsoleView consoleView = console;
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunConfiguration", "attachConsole"));
        }
        return consoleView;
    }

    @Override
    protected boolean supportMultipleDevices() {
        return true;
    }

    @Override
    @Nullable
    protected AndroidApplicationLauncher getApplicationLauncher(final AndroidFacet facet) {
        return new MyApplicationLauncher(){

            @Override
            @Nullable
            protected String getActivityName(@Nullable ProcessHandler processHandler) {
                return AndroidRunConfiguration.this.getActivityToLaunch(facet, processHandler);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private String getActivityToLaunch(final @NotNull AndroidFacet facet, @Nullable ProcessHandler processHandler) {
        String activityToLaunch;
        block8: {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidRunConfiguration", "getActivityToLaunch"));
            }
            activityToLaunch = null;
            if (this.MODE.equals(LAUNCH_DEFAULT_ACTIVITY)) {
                String defaultActivityName = AndroidRunConfiguration.computeDefaultActivity(facet, processHandler);
                if (defaultActivityName != null) {
                    activityToLaunch = defaultActivityName;
                    break block8;
                } else {
                    if (processHandler != null) {
                        processHandler.notifyTextAvailable(AndroidBundle.message("default.activity.not.found.error", new Object[0]), ProcessOutputTypes.STDERR);
                    }
                    return null;
                }
            }
            if (this.MODE.equals(LAUNCH_SPECIFIC_ACTIVITY)) {
                activityToLaunch = this.ACTIVITY_CLASS;
            }
        }
        if (activityToLaunch != null) {
            final String finalActivityToLaunch = activityToLaunch;
            String activityRuntimeQName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    GlobalSearchScope scope = facet.getModule().getModuleWithDependenciesAndLibrariesScope(false);
                    PsiClass activityClass = JavaPsiFacade.getInstance((Project)AndroidRunConfiguration.this.getProject()).findClass(finalActivityToLaunch, scope);
                    if (activityClass != null) {
                        return JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)activityClass);
                    }
                    return null;
                }
            });
            if (activityRuntimeQName != null) {
                return activityRuntimeQName;
            }
        }
        return activityToLaunch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static String computeDefaultActivity(@NotNull AndroidFacet facet, final @Nullable ProcessHandler processHandler) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidRunConfiguration", "computeDefaultActivity"));
        }
        if (!facet.getProperties().USE_CUSTOM_COMPILER_MANIFEST) {
            boolean useMergedManifest = facet.isGradleProject() || facet.getProperties().ENABLE_MANIFEST_MERGING;
            final ManifestInfo manifestInfo = ManifestInfo.get(facet.getModule(), useMergedManifest);
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return AndroidUtils.getDefaultLauncherActivityName(manifestInfo.getActivities(), manifestInfo.getActivityAliases());
                }
            });
        }
        File manifestCopy = null;
        try {
            Pair<File, String> pair = AndroidRunConfiguration.getCopyOfCompilerManifestFile(facet, processHandler);
            manifestCopy = pair != null ? (File)pair.getFirst() : null;
            VirtualFile manifestVFile = manifestCopy != null ? LocalFileSystem.getInstance().findFileByIoFile(manifestCopy) : null;
            final Manifest manifest = manifestVFile == null ? null : AndroidUtils.loadDomElement(facet.getModule(), manifestVFile, Manifest.class);
            String string = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    if (manifest == null) {
                        if (processHandler != null) {
                            processHandler.notifyTextAvailable("Cannot find AndroidManifest.xml file\n", ProcessOutputTypes.STDERR);
                        }
                        return null;
                    }
                    return AndroidUtils.getDefaultLauncherActivityName(manifest);
                }
            });
            return string;
        }
        finally {
            if (manifestCopy != null) {
                FileUtil.delete((File)manifestCopy.getParentFile());
            }
        }
    }

    private static boolean isActivityLaunchable(List<IntentFilter> intentFilters) {
        for (IntentFilter filter : intentFilters) {
            if (!AndroidDomUtil.containsAction(filter, "android.intent.action.MAIN")) continue;
            return true;
        }
        return false;
    }

    private static abstract class MyApplicationLauncher
    extends AndroidApplicationLauncher {
        private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.run.AndroidRunConfiguration.MyApplicationLauncher");

        private MyApplicationLauncher() {
        }

        @Nullable
        protected abstract String getActivityName(@Nullable ProcessHandler var1);

        @Override
        public boolean isReadyForDebugging(ClientData data, ProcessHandler processHandler) {
            String activityName = this.getActivityName(processHandler);
            if (activityName == null) {
                ClientData.DebuggerStatus status = data.getDebuggerConnectionStatus();
                switch (status) {
                    case ERROR: {
                        if (processHandler != null) {
                            processHandler.notifyTextAvailable("Debug port is busy\n", ProcessOutputTypes.STDOUT);
                        }
                        LOG.info("Debug port is busy");
                        return false;
                    }
                    case ATTACHED: {
                        if (processHandler != null) {
                            processHandler.notifyTextAvailable("Debugger already attached\n", ProcessOutputTypes.STDOUT);
                        }
                        LOG.info("Debugger already attached");
                        return false;
                    }
                }
                return true;
            }
            return super.isReadyForDebugging(data, processHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AndroidApplicationLauncher.LaunchResult launch(@NotNull AndroidRunningState state, @NotNull IDevice device) throws IOException, AdbCommandRejectedException, TimeoutException {
            boolean success;
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidRunConfiguration$MyApplicationLauncher", "launch"));
            }
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/run/AndroidRunConfiguration$MyApplicationLauncher", "launch"));
            }
            ProcessHandler processHandler = state.getProcessHandler();
            String activityName = this.getActivityName(processHandler);
            if (activityName == null) {
                return AndroidApplicationLauncher.LaunchResult.NOTHING_TO_DO;
            }
            activityName = activityName.replace("$", "\\$");
            String activityPath = state.getPackageName() + '/' + activityName;
            if (state.isStopped()) {
                return AndroidApplicationLauncher.LaunchResult.STOP;
            }
            processHandler.notifyTextAvailable("Launching application: " + activityPath + ".\n", ProcessOutputTypes.STDOUT);
            AndroidRunningState.MyReceiver receiver = new AndroidRunningState.MyReceiver(state);
            boolean debug = state.isDebugMode();
            while (true) {
                if (state.isStopped()) {
                    return AndroidApplicationLauncher.LaunchResult.STOP;
                }
                String command = "am start " + (debug ? "-D " : "") + "-n \"" + activityPath + "\" " + "-a android.intent.action.MAIN " + "-c android.intent.category.LAUNCHER";
                boolean deviceNotResponding = false;
                try {
                    state.executeDeviceCommandAndWriteToConsole(device, command, receiver);
                }
                catch (ShellCommandUnresponsiveException e) {
                    LOG.info((Throwable)e);
                    deviceNotResponding = true;
                }
                if (!deviceNotResponding && receiver.getErrorType() != 2) break;
                processHandler.notifyTextAvailable("Device is not ready. Waiting for 20 sec.\n", ProcessOutputTypes.STDOUT);
                Object object = state.getRunningLock();
                synchronized (object) {
                    try {
                        state.getRunningLock().wait(20000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                receiver = new AndroidRunningState.MyReceiver(state);
            }
            boolean bl = success = receiver.getErrorType() == -2;
            if (success) {
                processHandler.notifyTextAvailable(receiver.getOutput().toString(), ProcessOutputTypes.STDOUT);
            } else {
                processHandler.notifyTextAvailable(receiver.getOutput().toString(), ProcessOutputTypes.STDERR);
            }
            return success ? AndroidApplicationLauncher.LaunchResult.SUCCESS : AndroidApplicationLauncher.LaunchResult.STOP;
        }
    }
}

