/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProcessText {
    private static final Key<AndroidProcessText> KEY = new Key("ANDROID_PROCESS_TEXT");
    private final List<MyFragment> myFragments;

    private AndroidProcessText(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidProcessText", "<init>"));
        }
        this.myFragments = new ArrayList<MyFragment>();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTextAvailable(ProcessEvent event, Key outputType) {
                List list = AndroidProcessText.this.myFragments;
                synchronized (list) {
                    AndroidProcessText.this.myFragments.add(new MyFragment(event.getText(), outputType));
                }
            }
        });
        processHandler.putUserData(KEY, (Object)this);
    }

    public static void attach(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidProcessText", "attach"));
        }
        new AndroidProcessText(processHandler);
    }

    @Nullable
    public static AndroidProcessText get(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidProcessText", "get"));
        }
        return (AndroidProcessText)processHandler.getUserData(KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTo(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidProcessText", "printTo"));
        }
        List<MyFragment> list = this.myFragments;
        synchronized (list) {
            for (MyFragment fragment : this.myFragments) {
                processHandler.notifyTextAvailable(fragment.getText(), fragment.getOutputType());
            }
        }
    }

    private static class MyFragment {
        private final String myText;
        private final Key myOutputType;

        private MyFragment(@NotNull String text, @NotNull Key outputType) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidProcessText$MyFragment", "<init>"));
            }
            if (outputType == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/run/AndroidProcessText$MyFragment", "<init>"));
            }
            this.myText = text;
            this.myOutputType = outputType;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidProcessText$MyFragment", "getText"));
            }
            return string;
        }

        @NotNull
        public Key getOutputType() {
            Key key = this.myOutputType;
            if (key == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidProcessText$MyFragment", "getOutputType"));
            }
            return key;
        }
    }
}

