/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.resources.ResourceType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.android.dom.resources.Item;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.resourceManagers.ValueResourceInfoBase;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueResourceInfoImpl
extends ValueResourceInfoBase {
    private final Project myProject;
    private final int myOffset;

    ValueResourceInfoImpl(@NotNull String name, @NotNull ResourceType type, @NotNull VirtualFile file, @NotNull Project project, int offset) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/resourceManagers/ValueResourceInfoImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/resourceManagers/ValueResourceInfoImpl", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/resourceManagers/ValueResourceInfoImpl", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/resourceManagers/ValueResourceInfoImpl", "<init>"));
        }
        super(name, type, file);
        this.myProject = project;
        this.myOffset = offset;
    }

    @Override
    public XmlAttributeValue computeXmlElement() {
        ResourceElement resDomElement = this.computeDomElement();
        return resDomElement != null ? resDomElement.getName().getXmlAttributeValue() : null;
    }

    @Nullable
    public ResourceElement computeDomElement() {
        String resType;
        PsiFile file = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        if (!(file instanceof XmlFile)) {
            return null;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)this.myOffset, XmlTag.class, (boolean)true);
        if (tag == null) {
            return null;
        }
        DomElement domElement = DomManager.getDomManager((Project)this.myProject).getDomElement(tag);
        if (!(domElement instanceof ResourceElement)) {
            return null;
        }
        String string = resType = domElement instanceof Item ? ((Item)domElement).getType().getStringValue() : AndroidCommonUtils.getResourceTypeByTagName((String)tag.getName());
        if (!this.myType.getName().equals(resType)) {
            return null;
        }
        ResourceElement resDomElement = (ResourceElement)domElement;
        String resName = ((ResourceElement)domElement).getName().getStringValue();
        return this.myName.equals(resName) ? resDomElement : null;
    }

    @Override
    protected int getSortingRank() {
        return 1;
    }

    @Override
    public int compareTo(@NotNull ValueResourceInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/resourceManagers/ValueResourceInfoImpl", "compareTo"));
        }
        int delta = super.compareTo(other);
        if (delta != 0) {
            return delta;
        }
        assert (other instanceof ValueResourceInfoImpl);
        return this.myOffset - ((ValueResourceInfoImpl)other).myOffset;
    }
}

