/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.resources.ResourceType;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

abstract class ValueResourceInfoBase
implements ValueResourceInfo {
    protected final String myName;
    protected final ResourceType myType;
    protected final VirtualFile myFile;

    protected ValueResourceInfoBase(@NotNull String name, @NotNull ResourceType type, @NotNull VirtualFile file) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/resourceManagers/ValueResourceInfoBase", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/resourceManagers/ValueResourceInfoBase", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/resourceManagers/ValueResourceInfoBase", "<init>"));
        }
        this.myName = name;
        this.myType = type;
        this.myFile = file;
    }

    @Override
    @NotNull
    public VirtualFile getContainingFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ValueResourceInfoBase", "getContainingFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ValueResourceInfoBase", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public ResourceType getType() {
        ResourceType resourceType = this.myType;
        if (resourceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ValueResourceInfoBase", "getType"));
        }
        return resourceType;
    }

    public String toString() {
        return "ANDROID_RESOURCE: " + this.myType + ", " + this.myName + ", " + this.myFile.getPath() + "]";
    }

    @Override
    public int compareTo(@NotNull ValueResourceInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/resourceManagers/ValueResourceInfoBase", "compareTo"));
        }
        VirtualFile file1 = this.myFile;
        VirtualFile file2 = other.getContainingFile();
        int delta = AndroidResourceUtil.compareResourceFiles(file1, file2);
        if (delta != 0) {
            return delta;
        }
        return this.getSortingRank() - ((ValueResourceInfoBase)other).getSortingRank();
    }

    protected abstract int getSortingRank();
}

