/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.dom.layout.Include;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidBaseLayoutRefactoringAction;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidExtractAsIncludeAction
extends AndroidBaseLayoutRefactoringAction {
    @NonNls
    public static final String ACTION_ID = "AndroidExtractAsIncludeAction";
    private final MyTestConfig myTestConfig;

    public AndroidExtractAsIncludeAction() {
        this.myTestConfig = null;
    }

    public AndroidExtractAsIncludeAction(@Nullable MyTestConfig testConfig) {
        this.myTestConfig = testConfig;
    }

    @Override
    protected void doRefactorForTags(@NotNull Project project, @NotNull XmlTag[] tags) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/refactoring/AndroidExtractAsIncludeAction", "doRefactorForTags"));
        }
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/refactoring/AndroidExtractAsIncludeAction", "doRefactorForTags"));
        }
        if (tags.length == 0) {
            return;
        }
        PsiFile file = tags[0].getContainingFile();
        if (file == null) {
            return;
        }
        XmlTag startTag = null;
        XmlTag endTag = null;
        int startOffset = Integer.MAX_VALUE;
        int endOffset = -1;
        for (XmlTag tag : tags) {
            int end;
            TextRange range = tag.getTextRange();
            int start = range.getStartOffset();
            if (start < startOffset) {
                startOffset = start;
                startTag = tag;
            }
            if ((end = range.getEndOffset()) <= endOffset) continue;
            endOffset = end;
            endTag = tag;
        }
        assert (startTag != null && endTag != null);
        this.doRefactorForPsiRange(project, file, (PsiElement)startTag, (PsiElement)endTag);
    }

    @Override
    protected boolean isEnabledForTags(@NotNull XmlTag[] tags) {
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/refactoring/AndroidExtractAsIncludeAction", "isEnabledForTags"));
        }
        if (tags.length == 0) {
            return false;
        }
        DomManager domManager = DomManager.getDomManager((Project)tags[0].getProject());
        boolean containsViewElement = false;
        for (XmlTag tag : tags) {
            DomElement domElement = domManager.getDomElement(tag);
            if (!AndroidExtractAsIncludeAction.isSuitableDomElement(domElement)) {
                return false;
            }
            if (!(domElement instanceof LayoutViewElement)) continue;
            containsViewElement = true;
        }
        if (!containsViewElement) {
            return false;
        }
        PsiElement parent = tags[0].getParent();
        if (!(parent instanceof XmlTag) || parent.getContainingFile() == null) {
            return false;
        }
        for (int i = 1; i < tags.length; ++i) {
            if (tags[i].getParent() == parent) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doRefactorForPsiRange(@NotNull Project project, final @NotNull PsiFile file, final @NotNull PsiElement from, final @NotNull PsiElement to) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/refactoring/AndroidExtractAsIncludeAction", "doRefactorForPsiRange"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/refactoring/AndroidExtractAsIncludeAction", "doRefactorForPsiRange"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/refactoring/AndroidExtractAsIncludeAction", "doRefactorForPsiRange"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/refactoring/AndroidExtractAsIncludeAction", "doRefactorForPsiRange"));
        }
        PsiDirectory dir = file.getContainingDirectory();
        if (dir == null) {
            return;
        }
        final AndroidFacet facet = AndroidFacet.getInstance(from);
        assert (facet != null);
        final XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)from, XmlTag.class);
        assert (parentTag != null);
        final List<XmlTag> tagsInRange = AndroidExtractAsIncludeAction.collectAllTags(from, to);
        assert (tagsInRange.size() > 0) : "there is no tag inside the range";
        final String fileName = this.myTestConfig != null ? this.myTestConfig.myLayoutFileName : null;
        String dirName = dir.getName();
        final FolderConfiguration config = dirName.length() > 0 ? FolderConfiguration.getConfig((String[])dirName.split("-")) : null;
        String title = "Extract Android Layout";
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                final XmlFile newFile = CreateResourceFileAction.createFileResource(facet, ResourceType.LAYOUT, fileName, "temp_root", config, true, "Extract Android Layout");
                if (newFile != null) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            AndroidExtractAsIncludeAction.doRefactor(facet, file, newFile, from, to, parentTag, tagsInRange.size() > 1);
                        }
                    });
                }
            }
        }, "Extract Android Layout", null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
    }

    private static void doRefactor(AndroidFacet facet, PsiFile file, XmlFile newFile, PsiElement from, PsiElement to, XmlTag parentTag, boolean wrapWithMerge) {
        Project project = facet.getModule().getProject();
        String textToExtract = file.getText().substring(from.getTextRange().getStartOffset(), to.getTextRange().getEndOffset());
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument((PsiFile)newFile);
        assert (document != null);
        document.setText((CharSequence)("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + (wrapWithMerge ? "<merge>\n" + textToExtract + "\n</merge>" : textToExtract)));
        documentManager.commitDocument(document);
        HashSet unknownPrefixes = new HashSet();
        newFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor((Set)unknownPrefixes){
            final /* synthetic */ Set val$unknownPrefixes;
            {
                this.val$unknownPrefixes = set;
            }

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                String prefix = tag.getNamespacePrefix();
                if (!this.val$unknownPrefixes.contains(prefix) && tag.getNamespace().length() == 0) {
                    this.val$unknownPrefixes.add(prefix);
                }
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                String prefix = attribute.getNamespacePrefix();
                if (!this.val$unknownPrefixes.contains(prefix) && attribute.getNamespace().length() == 0) {
                    this.val$unknownPrefixes.add(prefix);
                }
            }
        });
        XmlTag rootTag = newFile.getRootTag();
        assert (rootTag != null);
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project);
        XmlAttribute[] attributes = rootTag.getAttributes();
        XmlAttribute firstAttribute = attributes.length > 0 ? attributes[0] : null;
        for (String prefix : unknownPrefixes) {
            String namespace = parentTag.getNamespaceByPrefix(prefix);
            String xmlNsAttrName = "xmlns:" + prefix;
            if (namespace.length() <= 0 || rootTag.getAttribute(xmlNsAttrName) != null) continue;
            XmlAttribute xmlnsAttr = elementFactory.createXmlAttribute(xmlNsAttrName, namespace);
            if (firstAttribute != null) {
                rootTag.addBefore((PsiElement)xmlnsAttr, (PsiElement)firstAttribute);
                continue;
            }
            rootTag.add((PsiElement)xmlnsAttr);
        }
        String includingLayout = "@layout/" + ResourceHelper.getResourceName(file);
        IncludeReference.setIncludingLayout(project, newFile, includingLayout);
        String resourceName = AndroidCommonUtils.getResourceName((String)ResourceType.LAYOUT.getName(), (String)newFile.getName());
        XmlTag includeTag = elementFactory.createTagFromText((CharSequence)("<include layout=\"@layout/" + resourceName + "\"/>"));
        parentTag.addAfter((PsiElement)includeTag, to);
        parentTag.deleteChildRange(from, to);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformat((PsiElement)newFile);
    }

    @NotNull
    private static List<XmlTag> collectAllTags(PsiElement from, PsiElement to) {
        PsiElement e;
        ArrayList<XmlTag> result = new ArrayList<XmlTag>();
        for (e = from; e != null; e = e.getNextSibling()) {
            if (e instanceof XmlTag) {
                result.add((XmlTag)e);
            }
            if (e == to) break;
        }
        assert (e != null) : "invalid range";
        ArrayList<XmlTag> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidExtractAsIncludeAction", "collectAllTags"));
        }
        return arrayList;
    }

    @Override
    protected boolean isEnabledForPsiRange(@NotNull PsiElement from, @Nullable PsiElement to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/refactoring/AndroidExtractAsIncludeAction", "isEnabledForPsiRange"));
        }
        DomManager domManager = DomManager.getDomManager((Project)from.getProject());
        boolean containsViewElement = false;
        for (PsiElement e = from; e != null; e = e.getNextSibling()) {
            if (e instanceof XmlTag) {
                DomElement domElement = domManager.getDomElement((XmlTag)e);
                if (!AndroidExtractAsIncludeAction.isSuitableDomElement(domElement)) {
                    return false;
                }
                if (domElement instanceof LayoutViewElement) {
                    containsViewElement = true;
                }
            }
            if (e == to) break;
        }
        return containsViewElement;
    }

    private static boolean isSuitableDomElement(DomElement element) {
        return element instanceof LayoutViewElement || element instanceof Include;
    }

    static class MyTestConfig {
        private final String myLayoutFileName;

        MyTestConfig(@NotNull String layoutFileName) {
            if (layoutFileName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/refactoring/AndroidExtractAsIncludeAction$MyTestConfig", "<init>"));
            }
            this.myLayoutFileName = layoutFileName;
        }
    }
}

