/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.projectView;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.BidirectionalMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Nullable;

public class ResourceQualifierSwitcher
extends EditorNotifications.Provider<ResourceQualifierSwitcherPanel> {
    private static final Key<ResourceQualifierSwitcherPanel> KEY = Key.create((String)"android.projectView.QualifierSwitcherPanel");
    private final Project myProject;

    public ResourceQualifierSwitcher(Project project) {
        this.myProject = project;
    }

    public Key<ResourceQualifierSwitcherPanel> getKey() {
        return KEY;
    }

    @Nullable
    public ResourceQualifierSwitcherPanel createNotificationPanel(VirtualFile file, FileEditor fileEditor) {
        AndroidFacet facet;
        if (!ApplicationManager.getApplication().isInternal()) {
            return null;
        }
        if (file.getFileType() != XmlFileType.INSTANCE) {
            return null;
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return null;
        }
        if ((parent = parent.getParent()) == null || !parent.getName().equals("res")) {
            return null;
        }
        Module module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)this.myProject);
        AndroidFacet androidFacet = facet = module == null ? null : AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        BidirectionalMap<String, VirtualFile> qualifiers = ResourceQualifierSwitcher.collectQualifiers(parent, file);
        if (qualifiers.size() <= 1) {
            return null;
        }
        return new ResourceQualifierSwitcherPanel(this.myProject, file, qualifiers);
    }

    private static BidirectionalMap<String, VirtualFile> collectQualifiers(VirtualFile resDirectory, VirtualFile file) {
        BidirectionalMap result = new BidirectionalMap();
        ResourceFolderType type = ResourceHelper.getFolderType(file);
        for (VirtualFile dir : resDirectory.getChildren()) {
            VirtualFile fileWithQualifier;
            ResourceFolderType otherType = ResourceFolderType.getFolderType((String)dir.getName());
            if (otherType != type || (fileWithQualifier = dir.findChild(file.getName())) == null) continue;
            String childName = dir.getName();
            int dashPos = childName.indexOf(45);
            String qualifier = dashPos > 0 ? childName.substring(dashPos + 1) : "<default>";
            result.put((Object)qualifier, (Object)fileWithQualifier);
        }
        return result;
    }

    public static class ResourceQualifierSwitcherPanel
    extends JPanel {
        private final Project myProject;
        private final VirtualFile myFile;
        private final BidirectionalMap<String, VirtualFile> myQualifiers;

        public ResourceQualifierSwitcherPanel(Project project, final VirtualFile file, BidirectionalMap<String, VirtualFile> qualifiers) {
            super(new BorderLayout());
            this.myProject = project;
            this.myFile = file;
            this.myQualifiers = qualifiers;
            String currentFileQualifier = (String)qualifiers.getKeysByValue((Object)file).get(0);
            final JLabel label = new JLabel(currentFileQualifier);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (event.getButton() != 1 || event.getClickCount() != 1) {
                        return;
                    }
                    BidirectionalMap map = ResourceQualifierSwitcher.collectQualifiers(file.getParent().getParent(), file);
                    BaseListPopupStep<String> popupStep = new BaseListPopupStep<String>("Choose Qualifier", new ArrayList(map.keySet())){

                        public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                            ResourceQualifierSwitcherPanel.this.switchToFile(selectedValue);
                            return FINAL_CHOICE;
                        }
                    };
                    ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep);
                    popup.showUnderneathOf((Component)label);
                }
            });
            this.add((Component)label, "West");
        }

        private void switchToFile(String qualifier) {
            VirtualFile newFile = (VirtualFile)this.myQualifiers.get((Object)qualifier);
            if (newFile != this.myFile) {
                FileEditorManager.getInstance((Project)this.myProject).openFile(newFile, true);
            }
        }
    }
}

