/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.newProject;

import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.ui.DocumentAdapter;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.android.newProject.AndroidAppPropertiesEditor;
import org.jetbrains.android.newProject.AndroidModifiedSettingsStep;
import org.jetbrains.android.newProject.AndroidModuleBuilder;
import org.jetbrains.annotations.NotNull;

class AndroidLibraryModifiedSettingsStep
extends AndroidModifiedSettingsStep {
    private final JTextField myPackageNameField;
    private boolean myPackageNameFieldChangedByUser;

    public AndroidLibraryModifiedSettingsStep(@NotNull AndroidModuleBuilder builder, final @NotNull SettingsStep settingsStep) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/newProject/AndroidLibraryModifiedSettingsStep", "<init>"));
        }
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/newProject/AndroidLibraryModifiedSettingsStep", "<init>"));
        }
        super(builder, settingsStep);
        this.myPackageNameField = new JTextField();
        this.updatePackageNameField(settingsStep);
        settingsStep.addSettingsField("Pa\u001bckage name: ", (JComponent)this.myPackageNameField);
        this.myPackageNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                AndroidLibraryModifiedSettingsStep.this.myPackageNameFieldChangedByUser = true;
            }
        });
        settingsStep.getModuleNameField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!AndroidLibraryModifiedSettingsStep.this.myPackageNameFieldChangedByUser) {
                    AndroidLibraryModifiedSettingsStep.this.updatePackageNameField(settingsStep);
                    AndroidLibraryModifiedSettingsStep.this.myPackageNameFieldChangedByUser = false;
                }
            }
        });
    }

    private void updatePackageNameField(SettingsStep settingsStep) {
        String moduleName = settingsStep.getModuleNameField().getText().trim();
        if (moduleName.length() > 0) {
            this.myPackageNameField.setText(AndroidAppPropertiesEditor.getDefaultPackageNameByModuleName(moduleName));
        }
    }

    public boolean validate() throws ConfigurationException {
        if (!super.validate()) {
            return false;
        }
        String message = AndroidAppPropertiesEditor.doValidatePackageName(true, this.getPackageName(), null);
        if (message.length() > 0) {
            throw new ConfigurationException(message);
        }
        return true;
    }

    @Override
    public void updateDataModel() {
        super.updateDataModel();
        this.myBuilder.setPackageName(this.getPackageName());
    }

    private String getPackageName() {
        return this.myPackageNameField.getText().trim();
    }
}

