/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.macro.VariableOfTypeMacro;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidLayoutPreviewToolWindowManager;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidAddStringResourceAction
extends AbstractIntentionAction
implements HighPriorityAction {
    private static final String CONTEXT = "android.content.Context";
    private static final String RESOURCES = "android.content.res.Resources";

    @NotNull
    public String getText() {
        String string = AndroidBundle.message("add.string.resource.intention.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/intentions/AndroidAddStringResourceAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/intentions/AndroidAddStringResourceAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/intentions/AndroidAddStringResourceAction", "isAvailable"));
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return false;
        }
        PsiElement element = AndroidAddStringResourceAction.getPsiElement(file, editor);
        return element != null && AndroidAddStringResourceAction.getStringLiteralValue(project, element, file, this.getType()) != null;
    }

    protected ResourceType getType() {
        return ResourceType.STRING;
    }

    @Nullable
    protected static String getStringLiteralValue(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiFile file, ResourceType resourceType) {
        ResourceValue value;
        Converter converter;
        GenericAttributeValue domAttribute;
        XmlAttribute attribute;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/intentions/AndroidAddStringResourceAction", "getStringLiteralValue"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/intentions/AndroidAddStringResourceAction", "getStringLiteralValue"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/intentions/AndroidAddStringResourceAction", "getStringLiteralValue"));
        }
        if (file instanceof PsiJavaFile && element instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            Object value2 = literalExpression.getValue();
            if (resourceType == ResourceType.STRING && value2 instanceof String) {
                return (String)value2;
            }
            if (resourceType == ResourceType.DIMEN && (value2 instanceof Integer || value2 instanceof Float)) {
                return value2.toString();
            }
        } else if (file instanceof XmlFile && element instanceof XmlAttributeValue && (attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class)) != null && (domAttribute = DomManager.getDomManager((Project)project).getDomElement(attribute)) != null && (converter = domAttribute.getConverter()) instanceof ResourceReferenceConverter && (value = (ResourceValue)domAttribute.getValue()) != null && !value.isReference()) {
            Set<String> types = ((ResourceReferenceConverter)converter).getResourceTypes((DomElement)domAttribute);
            String typeName = resourceType.getName();
            for (String type : types) {
                if (!typeName.equals(type)) continue;
                return ((XmlAttributeValue)element).getValue();
            }
        }
        return null;
    }

    @Nullable
    private static PsiClass getContainingInheritorOf(@NotNull PsiElement element, String ... baseClassNames) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/intentions/AndroidAddStringResourceAction", "getContainingInheritorOf"));
        }
        if (baseClassNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/intentions/AndroidAddStringResourceAction", "getContainingInheritorOf"));
        }
        PsiClass c = null;
        do {
            c = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)(c == null ? element : c), PsiClass.class);
            for (String name : baseClassNames) {
                if (!InheritanceUtil.isInheritor((PsiClass)c, (String)name)) continue;
                return c;
            }
        } while (c != null);
        return null;
    }

    @Nullable
    protected static PsiElement getPsiElement(PsiFile file, Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        return element != null ? element.getParent() : null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/intentions/AndroidAddStringResourceAction", "invoke"));
        }
        AndroidAddStringResourceAction.doInvoke(project, editor, file, null, this.getType());
    }

    static void doInvoke(Project project, Editor editor, PsiFile file, @Nullable String resName, ResourceType type) {
        PsiElement element = AndroidAddStringResourceAction.getPsiElement(file, editor);
        assert (element != null);
        AndroidAddStringResourceAction.doInvoke(project, editor, file, resName, element, type);
    }

    protected static void doInvoke(Project project, Editor editor, PsiFile file, @Nullable String resName, PsiElement element, ResourceType type) {
        String value = AndroidAddStringResourceAction.getStringLiteralValue(project, element, file, type);
        assert (value != null);
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        assert (facet != null);
        String aPackage = AndroidAddStringResourceAction.getPackage(facet);
        if (aPackage == null) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("package.not.found.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        if (resName == null) {
            Module facetModule = facet.getModule();
            boolean chooseName = ResourceHelper.prependResourcePrefix(facetModule, null) != null;
            CreateXmlResourceDialog dialog = new CreateXmlResourceDialog(facetModule, type, null, value, chooseName);
            dialog.setTitle("Extract Resource");
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
            Module module = dialog.getModule();
            if (module == null) {
                return;
            }
            resName = dialog.getResourceName();
            if (!AndroidResourceUtil.createValueResource(module, resName, type, dialog.getFileName(), dialog.getDirNames(), value)) {
                return;
            }
        } else {
            String fileName = AndroidResourceUtil.getDefaultResourceFileName(type);
            assert (ApplicationManager.getApplication().isUnitTestMode());
            assert (fileName != null);
            AndroidResourceUtil.createValueResource(facet.getModule(), resName, type, fileName, Collections.singletonList(ResourceFolderType.VALUES.getName()), value);
        }
        if (file instanceof PsiJavaFile) {
            AndroidAddStringResourceAction.createJavaResourceReference(facet.getModule(), editor, file, element, aPackage, resName, type);
        } else {
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
            if (attribute != null) {
                attribute.setValue(ResourceValue.referenceTo('@', null, type.getName(), resName).toString());
            }
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        UndoUtil.markPsiFileForUndo((PsiFile)file);
        AndroidLayoutPreviewToolWindowManager.renderIfApplicable(project);
    }

    private static void createJavaResourceReference(Module module, Editor editor, final PsiFile file, PsiElement element, String aPackage, String resName, ResourceType resType) {
        TemplateImpl template;
        boolean extendsContext = AndroidAddStringResourceAction.getContainingInheritorOf(element, CONTEXT) != null;
        String rJavaFieldName = AndroidResourceUtil.getRJavaFieldName(resName);
        String field = aPackage + ".R." + resType + '.' + rJavaFieldName;
        String methodName = AndroidAddStringResourceAction.getGetterNameForResourceType(resType, element);
        assert (methodName != null);
        boolean inStaticContext = RefactoringUtil.isInStaticContext((PsiElement)element, null);
        final Project project = module.getProject();
        if (extendsContext && !inStaticContext) {
            if (ResourceType.STRING == resType) {
                template = new TemplateImpl("", methodName + '(' + field + ')', "");
            } else {
                template = new TemplateImpl("", "$resources$." + methodName + "(" + field + ")", "");
                MacroCallNode node = new MacroCallNode((Macro)new MyVarOfTypeExpression("getResources()"));
                node.addParameter((Expression)new ConstantNode(RESOURCES));
                template.addVariable("resources", (Expression)node, (Expression)new ConstantNode(""), true);
            }
        } else {
            template = ResourceType.STRING == resType ? new TemplateImpl("", "$context$." + methodName + "(" + field + ")", "") : new TemplateImpl("", "$context$.getResources()." + methodName + "(" + field + ")", "");
            boolean extendsView = AndroidAddStringResourceAction.getContainingInheritorOf(element, "android.view.View") != null;
            MacroCallNode node = new MacroCallNode((Macro)(extendsView && !inStaticContext ? new MyVarOfTypeExpression("getContext()") : new VariableOfTypeMacro()));
            node.addParameter((Expression)new ConstantNode(CONTEXT));
            template.addVariable("context", (Expression)node, (Expression)new ConstantNode(""), true);
        }
        int offset = element.getTextOffset();
        editor.getCaretModel().moveToOffset(offset);
        TextRange elementRange = element.getTextRange();
        editor.getDocument().deleteString(elementRange.getStartOffset(), elementRange.getEndOffset());
        final RangeMarker marker = editor.getDocument().createRangeMarker(offset, offset);
        marker.setGreedyToLeft(true);
        marker.setGreedyToRight(true);
        TemplateManager.getInstance((Project)project).startTemplate(editor, (Template)template, false, null, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void waitingForInput(Template template) {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)file, marker.getStartOffset(), marker.getEndOffset());
            }

            public void beforeTemplateFinished(TemplateState state, Template template) {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)file, marker.getStartOffset(), marker.getEndOffset());
            }
        });
    }

    @Nullable
    private static String getPackage(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/intentions/AndroidAddStringResourceAction", "getPackage"));
        }
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return null;
        }
        return (String)manifest.getPackage().getValue();
    }

    @Nullable
    private static String getGetterNameForResourceType(@NotNull ResourceType resourceType, @NotNull PsiElement element) {
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/intentions/AndroidAddStringResourceAction", "getGetterNameForResourceType"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/intentions/AndroidAddStringResourceAction", "getGetterNameForResourceType"));
        }
        String type = resourceType.getName();
        if (type.length() < 2) {
            return null;
        }
        if (resourceType == ResourceType.DIMEN) {
            PsiType targetType = AndroidAddStringResourceAction.computeTargetType(element);
            if (targetType != null && targetType == PsiType.INT) {
                return "getDimensionPixelSize";
            }
            return "getDimension";
        }
        return "get" + Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Nullable
    private static PsiType computeTargetType(PsiElement element) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        if (call != null) {
            PsiMethod resolved;
            int index;
            PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpressionList.class, (boolean)true);
            if (expressionList != null && (index = ArrayUtil.indexOf((Object[])expressionList.getExpressions(), (Object)element)) >= 0 && (resolved = call.resolveMethod()) != null) {
                PsiParameterList parameterList = resolved.getParameterList();
                if (index >= 0 && index < parameterList.getParametersCount()) {
                    PsiParameter psiParameter = parameterList.getParameters()[index];
                    return psiParameter.getType();
                }
            }
        } else {
            PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class, (boolean)false);
            if (variable != null) {
                return variable.getType();
            }
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static class MyVarOfTypeExpression
    extends VariableOfTypeMacro {
        private final String myDefaultValue;

        private MyVarOfTypeExpression(@NotNull String defaultValue) {
            if (defaultValue == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/intentions/AndroidAddStringResourceAction$MyVarOfTypeExpression", "<init>"));
            }
            this.myDefaultValue = defaultValue;
        }

        public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/intentions/AndroidAddStringResourceAction$MyVarOfTypeExpression", "calculateResult"));
            }
            return new TextResult(this.myDefaultValue);
        }

        public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/intentions/AndroidAddStringResourceAction$MyVarOfTypeExpression", "calculateQuickResult"));
            }
            return new TextResult(this.myDefaultValue);
        }

        public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/intentions/AndroidAddStringResourceAction$MyVarOfTypeExpression", "calculateLookupItems"));
            }
            PsiElement[] vars = this.getVariables(params, context);
            if (vars == null || vars.length == 0) {
                return null;
            }
            LinkedHashSet set = new LinkedHashSet();
            for (PsiElement var : vars) {
                JavaTemplateUtil.addElementLookupItem(set, (PsiElement)var);
            }
            LookupElement[] elements = set.toArray(new LookupElement[set.size()]);
            if (elements.length == 0) {
                return elements;
            }
            LookupElementBuilder lookupElementForDefValue = LookupElementBuilder.create((String)this.myDefaultValue);
            LookupElement[] result = new LookupElement[elements.length + 1];
            result[0] = lookupElementForDefValue;
            System.arraycopy(elements, 0, result, 1, elements.length);
            return result;
        }
    }
}

