/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.intellij.openapi.editor.Editor;
import org.jetbrains.annotations.NotNull;

public class AndroidQuickfixContexts {

    public static class DesignerContext
    extends Context {
        public static final ContextType TYPE = new ContextType();
        private static final DesignerContext INSTANCE = new DesignerContext();

        private DesignerContext() {
            super(TYPE);
        }

        @NotNull
        public static DesignerContext getInstance() {
            DesignerContext designerContext = INSTANCE;
            if (designerContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidQuickfixContexts$DesignerContext", "getInstance"));
            }
            return designerContext;
        }
    }

    public static class EditorContext
    extends Context {
        public static final ContextType TYPE = new ContextType();
        private final Editor myEditor;

        private EditorContext(@NotNull Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidQuickfixContexts$EditorContext", "<init>"));
            }
            super(TYPE);
            this.myEditor = editor;
        }

        @NotNull
        public Editor getEditor() {
            Editor editor = this.myEditor;
            if (editor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidQuickfixContexts$EditorContext", "getEditor"));
            }
            return editor;
        }

        @NotNull
        public static EditorContext getInstance(@NotNull Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidQuickfixContexts$EditorContext", "getInstance"));
            }
            EditorContext editorContext = new EditorContext(editor);
            if (editorContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidQuickfixContexts$EditorContext", "getInstance"));
            }
            return editorContext;
        }
    }

    public static class BatchContext
    extends Context {
        public static final ContextType TYPE = new ContextType();
        private static final BatchContext INSTANCE = new BatchContext();

        private BatchContext() {
            super(TYPE);
        }

        @NotNull
        public static BatchContext getInstance() {
            BatchContext batchContext = INSTANCE;
            if (batchContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidQuickfixContexts$BatchContext", "getInstance"));
            }
            return batchContext;
        }
    }

    public static class ContextType {
        private ContextType() {
        }
    }

    public static abstract class Context {
        private final ContextType myType;

        private Context(@NotNull ContextType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidQuickfixContexts$Context", "<init>"));
            }
            this.myType = type;
        }

        @NotNull
        public ContextType getType() {
            ContextType contextType = this.myType;
            if (contextType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidQuickfixContexts$Context", "getType"));
            }
            return contextType;
        }
    }
}

