/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.importDependencies;

import com.intellij.openapi.module.Module;
import org.jetbrains.android.importDependencies.ModuleProvidingTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ModuleProvider {
    private ModuleProvider() {
    }

    @Nullable
    public abstract Module getModule();

    @NotNull
    public abstract String getModuleName();

    public static ModuleProvider create(@NotNull ModuleProvidingTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/importDependencies/ModuleProvider", "create"));
        }
        return new MyNewModuleProvider(task);
    }

    public static ModuleProvider create(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/importDependencies/ModuleProvider", "create"));
        }
        return new MyExistingModuleProvider(module);
    }

    private static class MyExistingModuleProvider
    extends ModuleProvider {
        private final Module myModule;

        public MyExistingModuleProvider(Module module) {
            this.myModule = module;
        }

        @Override
        public Module getModule() {
            return this.myModule;
        }

        @Override
        @NotNull
        public String getModuleName() {
            String string = this.myModule.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/importDependencies/ModuleProvider$MyExistingModuleProvider", "getModuleName"));
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyExistingModuleProvider that = (MyExistingModuleProvider)o;
            return this.myModule.equals(that.myModule);
        }

        public int hashCode() {
            return this.myModule.hashCode();
        }
    }

    private static class MyNewModuleProvider
    extends ModuleProvider {
        private final ModuleProvidingTask myTask;

        public MyNewModuleProvider(@NotNull ModuleProvidingTask task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/importDependencies/ModuleProvider$MyNewModuleProvider", "<init>"));
            }
            this.myTask = task;
        }

        @Override
        public Module getModule() {
            return this.myTask.getDepModule();
        }

        @Override
        @NotNull
        public String getModuleName() {
            String string = this.myTask.getModuleName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/importDependencies/ModuleProvider$MyNewModuleProvider", "getModuleName"));
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyNewModuleProvider that = (MyNewModuleProvider)o;
            return this.myTask.equals(that.myTask);
        }

        public int hashCode() {
            return this.myTask.hashCode();
        }
    }
}

