/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.importDependencies;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

class ImportSourceRootsDialog
extends DialogWrapper {
    private final ElementsChooser<JavaModuleSourceRoot> mySourcePathsChooser;

    public ImportSourceRootsDialog(@NotNull Project project, @NotNull List<JavaModuleSourceRoot> sourceRoots) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/importDependencies/ImportSourceRootsDialog", "<init>"));
        }
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/importDependencies/ImportSourceRootsDialog", "<init>"));
        }
        super(project, false);
        this.setTitle(AndroidBundle.message("android.import.dependencies.source.roots.dialog.title", new Object[0]));
        this.mySourcePathsChooser = new ElementsChooser<JavaModuleSourceRoot>(true){

            public String getItemText(@NotNull JavaModuleSourceRoot sourceRoot) {
                if (sourceRoot == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/importDependencies/ImportSourceRootsDialog$1", "getItemText"));
                }
                String packagePrefix = sourceRoot.getPackagePrefix();
                String path = sourceRoot.getDirectory().getAbsolutePath();
                return packagePrefix.length() > 0 ? path + " (" + packagePrefix + ")" : path;
            }
        };
        this.mySourcePathsChooser.setElements(sourceRoots, true);
        this.init();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(350, 200));
        JBLabel label = new JBLabel(AndroidBundle.message("android.import.dependencies.source.roots.dialog.label", new Object[0]));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        panel.add((Component)label, "North");
        panel.add((Component)this.mySourcePathsChooser, "Center");
        return panel;
    }

    public List<JavaModuleSourceRoot> getMarkedElements() {
        return this.mySourcePathsChooser.getMarkedElements();
    }
}

