/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.importDependencies;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import org.jetbrains.android.importDependencies.ImportDependenciesTask;
import org.jetbrains.android.importDependencies.ModuleProvider;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddModuleDependencyTask
extends ImportDependenciesTask {
    private final ModuleProvider myModuleProvider;
    private final ModuleProvider myDepModuleProvider;

    public AddModuleDependencyTask(@NotNull ModuleProvider moduleProvider, @NotNull ModuleProvider depModuleProvider) {
        if (moduleProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/importDependencies/AddModuleDependencyTask", "<init>"));
        }
        if (depModuleProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/importDependencies/AddModuleDependencyTask", "<init>"));
        }
        this.myModuleProvider = moduleProvider;
        this.myDepModuleProvider = depModuleProvider;
    }

    @Override
    @Nullable
    public Exception perform() {
        Module module = this.myModuleProvider.getModule();
        Module depModule = this.myDepModuleProvider.getModule();
        if (module == null || depModule == null) {
            return null;
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        if (!rootManager.isDependsOn(depModule)) {
            ModuleRootModificationUtil.addDependency((Module)module, (Module)depModule);
        }
        return null;
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = AndroidBundle.message("android.import.dependencies.add.module.dependency.task.title", this.myModuleProvider.getModuleName(), this.myDepModuleProvider.getModuleName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/importDependencies/AddModuleDependencyTask", "getTitle"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddModuleDependencyTask that = (AddModuleDependencyTask)o;
        if (!this.myDepModuleProvider.equals(that.myDepModuleProvider)) {
            return false;
        }
        return this.myModuleProvider.equals(that.myModuleProvider);
    }

    public int hashCode() {
        int result = this.myModuleProvider.hashCode();
        result = 31 * result + this.myDepModuleProvider.hashCode();
        return result;
    }
}

