/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.formatter;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.codeStyle.arrangement.std.StdRulePriorityAwareSettings;
import com.intellij.psi.formatter.xml.XmlCodeStyleSettings;
import com.intellij.xml.arrangement.XmlRearranger;
import java.util.ArrayList;
import org.jetbrains.android.formatter.AndroidXmlCodeStyleSettings;

public class AndroidXmlPredefinedCodeStyle
extends PredefinedCodeStyle {
    public AndroidXmlPredefinedCodeStyle() {
        super("Android", (Language)XMLLanguage.INSTANCE);
    }

    public void apply(CodeStyleSettings settings) {
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)XmlFileType.INSTANCE);
        indentOptions.CONTINUATION_INDENT_SIZE = indentOptions.INDENT_SIZE;
        XmlCodeStyleSettings xmlSettings = (XmlCodeStyleSettings)settings.getCustomSettings(XmlCodeStyleSettings.class);
        xmlSettings.XML_ALIGN_ATTRIBUTES = false;
        xmlSettings.XML_SPACE_INSIDE_EMPTY_TAG = true;
        xmlSettings.XML_KEEP_LINE_BREAKS = false;
        AndroidXmlCodeStyleSettings androidSettings = AndroidXmlCodeStyleSettings.getInstance(settings);
        androidSettings.USE_CUSTOM_SETTINGS = true;
        androidSettings.LAYOUT_SETTINGS = new AndroidXmlCodeStyleSettings.LayoutSettings();
        androidSettings.MANIFEST_SETTINGS = new AndroidXmlCodeStyleSettings.ManifestSettings();
        androidSettings.VALUE_RESOURCE_FILE_SETTINGS = new AndroidXmlCodeStyleSettings.ValueResourceFileSettings();
        androidSettings.OTHER_SETTINGS = new AndroidXmlCodeStyleSettings.OtherSettings();
        ArrayList<StdArrangementMatchRule> rules = new ArrayList<StdArrangementMatchRule>();
        rules.add(XmlRearranger.attrArrangementRule((String)"xmlns:android", (String)"", (ArrangementSettingsToken)StdArrangementTokens.Order.KEEP));
        rules.add(XmlRearranger.attrArrangementRule((String)"xmlns:.*", (String)"", (ArrangementSettingsToken)StdArrangementTokens.Order.BY_NAME));
        rules.add(XmlRearranger.attrArrangementRule((String)".*:id", (String)"http://schemas.android.com/apk/res/android", (ArrangementSettingsToken)StdArrangementTokens.Order.KEEP));
        rules.add(XmlRearranger.attrArrangementRule((String)".*:name", (String)"http://schemas.android.com/apk/res/android", (ArrangementSettingsToken)StdArrangementTokens.Order.KEEP));
        rules.add(XmlRearranger.attrArrangementRule((String)"name", (String)"^$", (ArrangementSettingsToken)StdArrangementTokens.Order.KEEP));
        rules.add(XmlRearranger.attrArrangementRule((String)"style", (String)"^$", (ArrangementSettingsToken)StdArrangementTokens.Order.KEEP));
        rules.add(XmlRearranger.attrArrangementRule((String)".*", (String)"^$", (ArrangementSettingsToken)StdArrangementTokens.Order.BY_NAME));
        rules.add(XmlRearranger.attrArrangementRule((String)".*:layout_width", (String)"http://schemas.android.com/apk/res/android", (ArrangementSettingsToken)StdArrangementTokens.Order.KEEP));
        rules.add(XmlRearranger.attrArrangementRule((String)".*:layout_height", (String)"http://schemas.android.com/apk/res/android", (ArrangementSettingsToken)StdArrangementTokens.Order.KEEP));
        rules.add(XmlRearranger.attrArrangementRule((String)".*:layout_.*", (String)"http://schemas.android.com/apk/res/android", (ArrangementSettingsToken)StdArrangementTokens.Order.BY_NAME));
        rules.add(XmlRearranger.attrArrangementRule((String)".*:width", (String)"http://schemas.android.com/apk/res/android", (ArrangementSettingsToken)StdArrangementTokens.Order.BY_NAME));
        rules.add(XmlRearranger.attrArrangementRule((String)".*:height", (String)"http://schemas.android.com/apk/res/android", (ArrangementSettingsToken)StdArrangementTokens.Order.BY_NAME));
        rules.add(XmlRearranger.attrArrangementRule((String)".*", (String)"http://schemas.android.com/apk/res/android", (ArrangementSettingsToken)StdArrangementTokens.Order.BY_NAME));
        rules.add(XmlRearranger.attrArrangementRule((String)".*", (String)".*", (ArrangementSettingsToken)StdArrangementTokens.Order.BY_NAME));
        CommonCodeStyleSettings xmlCommonSettings = settings.getCommonSettings((Language)XMLLanguage.INSTANCE);
        xmlCommonSettings.setArrangementSettings((ArrangementSettings)new StdRulePriorityAwareSettings(rules));
        xmlCommonSettings.FORCE_REARRANGE_MODE = CommonCodeStyleSettings.REARRANGE_ALWAYS;
    }
}

