/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.wrappers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueResourceElementWrapper
implements XmlAttributeValue,
ResourceElementWrapper,
PsiNamedElement,
PsiElementNavigationItem {
    private final XmlAttributeValue myWrappee;
    private final String myFileName;
    private final String myDirName;

    public ValueResourceElementWrapper(@NotNull XmlAttributeValue wrappeeElement) {
        if (wrappeeElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "<init>"));
        }
        if (!(wrappeeElement instanceof NavigationItem)) {
            throw new IllegalArgumentException();
        }
        if (!(wrappeeElement instanceof PsiMetaOwner)) {
            throw new IllegalArgumentException();
        }
        this.myWrappee = wrappeeElement;
        PsiFile file = this.getContainingFile();
        this.myFileName = file != null ? file.getName() : null;
        PsiDirectory dir = file != null ? file.getContainingDirectory() : null;
        this.myDirName = dir != null ? dir.getName() : null;
    }

    @Override
    public PsiElement getWrappee() {
        return this.myWrappee;
    }

    @NotNull
    public Project getProject() throws PsiInvalidElementAccessException {
        Project project = this.myWrappee.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "getProject"));
        }
        return project;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myWrappee.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "getLanguage"));
        }
        return language;
    }

    public PsiManager getManager() {
        return this.myWrappee.getManager();
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.myWrappee.getChildren();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "getChildren"));
        }
        return psiElementArray;
    }

    public PsiElement getParent() {
        return this.myWrappee.getParent();
    }

    @Nullable
    public PsiElement getFirstChild() {
        return this.myWrappee.getFirstChild();
    }

    @Nullable
    public PsiElement getLastChild() {
        return this.myWrappee.getLastChild();
    }

    @Nullable
    public PsiElement getNextSibling() {
        return this.myWrappee.getNextSibling();
    }

    @Nullable
    public PsiElement getPrevSibling() {
        return this.myWrappee.getPrevSibling();
    }

    public PsiFile getContainingFile() throws PsiInvalidElementAccessException {
        return this.myWrappee.getContainingFile();
    }

    public TextRange getTextRange() {
        return this.myWrappee.getTextRange();
    }

    public int getStartOffsetInParent() {
        return this.myWrappee.getStartOffsetInParent();
    }

    public int getTextLength() {
        return this.myWrappee.getTextLength();
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return this.myWrappee.findElementAt(offset);
    }

    @Nullable
    public PsiReference findReferenceAt(int offset) {
        return this.myWrappee.findReferenceAt(offset);
    }

    public int getTextOffset() {
        return this.myWrappee.getTextOffset();
    }

    @NonNls
    public String getText() {
        return this.myWrappee.getText();
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.myWrappee.textToCharArray();
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "textToCharArray"));
        }
        return cArray;
    }

    public PsiElement getNavigationElement() {
        return this.myWrappee.getNavigationElement();
    }

    public PsiElement getOriginalElement() {
        return this.myWrappee.getOriginalElement();
    }

    public boolean textMatches(@NotNull @NonNls CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "textMatches"));
        }
        return this.myWrappee.textMatches(text);
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "textMatches"));
        }
        return this.myWrappee.textMatches(element);
    }

    public boolean textContains(char c) {
        return this.myWrappee.textContains(c);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "accept"));
        }
        this.myWrappee.accept(visitor);
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "acceptChildren"));
        }
        this.myWrappee.acceptChildren(visitor);
    }

    public PsiElement copy() {
        return this.myWrappee.copy();
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "add"));
        }
        return this.myWrappee.add(element);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "addBefore"));
        }
        return this.myWrappee.addBefore(element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "addAfter"));
        }
        return this.myWrappee.addAfter(element, anchor);
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "checkAdd"));
        }
        this.myWrappee.checkAdd(element);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return this.myWrappee.addRange(first, last);
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "addRangeBefore"));
        }
        return this.myWrappee.addRangeBefore(first, last, anchor);
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return this.myWrappee.addRangeAfter(first, last, anchor);
    }

    public void delete() throws IncorrectOperationException {
        this.myWrappee.delete();
    }

    public void checkDelete() throws IncorrectOperationException {
        this.myWrappee.checkDelete();
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        this.myWrappee.deleteChildRange(first, last);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "replace"));
        }
        return this.myWrappee.replace(newElement);
    }

    public boolean isValid() {
        return this.myWrappee.isValid();
    }

    public boolean isWritable() {
        return this.myWrappee.isWritable();
    }

    @Nullable
    public PsiReference getReference() {
        return this.myWrappee.getReference();
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = this.myWrappee.getReferences();
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Nullable
    public <T> T getCopyableUserData(Key<T> key) {
        return (T)this.myWrappee.getCopyableUserData(key);
    }

    public <T> void putCopyableUserData(Key<T> key, T value) {
        this.myWrappee.putCopyableUserData(key, value);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "processDeclarations"));
        }
        return this.myWrappee.processDeclarations(processor, state, lastParent, place);
    }

    @Nullable
    public PsiElement getContext() {
        return this.myWrappee.getContext();
    }

    public boolean isPhysical() {
        return this.myWrappee.isPhysical();
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myWrappee.getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = this.myWrappee.getUseScope();
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "getUseScope"));
        }
        return searchScope;
    }

    @Nullable
    public ASTNode getNode() {
        return this.myWrappee.getNode();
    }

    @NonNls
    public String toString() {
        return this.myWrappee.toString();
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof ResourceElementWrapper) {
            another = ((ResourceElementWrapper)another).getWrappee();
        }
        return this.myWrappee == another || this.myWrappee.isEquivalentTo(another);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueResourceElementWrapper that = (ValueResourceElementWrapper)o;
        return this.myWrappee.equals(that.myWrappee);
    }

    public int hashCode() {
        return this.myWrappee.hashCode();
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "getUserData"));
        }
        return (T)this.myWrappee.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "putUserData"));
        }
        this.myWrappee.putUserData(key, value);
    }

    public Icon getIcon(int flags) {
        return this.myWrappee.getIcon(flags);
    }

    public String getName() {
        String value = this.myWrappee.getValue();
        if (value.startsWith("@+id/")) {
            return AndroidResourceUtil.getResourceNameByReferenceText(value);
        }
        return ((NavigationItem)this.myWrappee).getName();
    }

    @Nullable
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/wrappers/ValueResourceElementWrapper", "setName"));
        }
        if (AndroidResourceUtil.isIdDeclaration(this.myWrappee)) {
            XmlAttribute attribute = (XmlAttribute)this.myWrappee.getParent();
            attribute.setValue(name);
        } else {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myWrappee, XmlTag.class);
            DomElement domElement = DomManager.getDomManager((Project)this.getProject()).getDomElement(tag);
            assert (domElement instanceof ResourceElement);
            ResourceElement resElement = (ResourceElement)domElement;
            resElement.getName().setValue((Object)name);
        }
        return null;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                String name = ((NavigationItem)ValueResourceElementWrapper.this.myWrappee).getName();
                if (ValueResourceElementWrapper.this.myDirName == null || ValueResourceElementWrapper.this.myFileName == null) {
                    return name;
                }
                return name + " (..." + File.separatorChar + ValueResourceElementWrapper.this.myDirName + File.separatorChar + ValueResourceElementWrapper.this.myFileName + ')';
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return null;
            }
        };
    }

    public void navigate(boolean requestFocus) {
        ((NavigationItem)this.myWrappee).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return ((NavigationItem)this.myWrappee).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((NavigationItem)this.myWrappee).canNavigateToSource();
    }

    public String getValue() {
        return this.myWrappee.getValue();
    }

    public TextRange getValueTextRange() {
        return this.myWrappee.getValueTextRange();
    }

    public boolean processElements(PsiElementProcessor processor, PsiElement place) {
        return this.myWrappee.processElements(processor, place);
    }

    public PsiElement getTargetElement() {
        return this.getWrappee();
    }
}

