/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.resources;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.ResourceNameValidator;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.CreateValueResourceQuickFix;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceNameConverter
extends ResolvingConverter<String>
implements CustomReferenceConverter<String> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        String fieldName = AndroidResourceUtil.getFieldNameByResourceName(s);
        return StringUtil.isJavaIdentifier((String)fieldName) && !JavaLexer.isKeyword((String)fieldName, (LanguageLevel)LanguageLevel.JDK_1_5) ? s : null;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        String message;
        if (s != null && (message = ResourceNameValidator.create(false, ResourceFolderType.VALUES).getErrorText(s)) != null) {
            return message;
        }
        return AndroidBundle.message("invalid.resource.name.error", s);
    }

    @NotNull
    public Collection<? extends String> getVariants(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        if (!(element instanceof GenericAttributeValue)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/resources/ResourceNameConverter", "getVariants"));
            }
            return list;
        }
        if (element.getParent() instanceof Style) {
            Collection<? extends String> collection = ResourceNameConverter.getStyleNameVariants(context, (GenericAttributeValue)element);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/resources/ResourceNameConverter", "getVariants"));
            }
            return collection;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/resources/ResourceNameConverter", "getVariants"));
        }
        return list;
    }

    private static Collection<? extends String> getStyleNameVariants(ConvertContext context, GenericAttributeValue element) {
        Module module = context.getModule();
        if (module == null) {
            return Collections.emptyList();
        }
        LocalResourceManager manager = LocalResourceManager.getInstance(module);
        if (manager == null) {
            return Collections.emptyList();
        }
        Collection<String> styleNames = manager.getResourceNames(ResourceType.STYLE.getName());
        ArrayList<String> result = new ArrayList<String>();
        String currentValue = element.getStringValue();
        for (String name : styleNames) {
            if (currentValue != null && currentValue.startsWith(name)) continue;
            result.add(name + '.');
        }
        return result;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value, PsiElement element, ConvertContext context) {
        Module module = context.getModule();
        if (module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/resources/ResourceNameConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/resources/ResourceNameConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        DomElement parent = value.getParent();
        if (parent instanceof Style) {
            PsiReference[] psiReferenceArray = ResourceNameConverter.getReferencesInStyleName((Style)parent, value, facet);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/resources/ResourceNameConverter", "createReferences"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/resources/ResourceNameConverter", "createReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiReference[] getReferencesInStyleName(@NotNull Style style, @NotNull GenericDomValue<String> value, @NotNull AndroidFacet facet) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/resources/ResourceNameConverter", "getReferencesInStyleName"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/dom/resources/ResourceNameConverter", "getReferencesInStyleName"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/dom/resources/ResourceNameConverter", "getReferencesInStyleName"));
        }
        String s = value.getStringValue();
        if (s == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        String[] ids = s.split("\\.");
        if (ids.length < 2 || style.getParentStyle().getStringValue() != null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<MyParentStyleReference> result = new ArrayList<MyParentStyleReference>(ids.length - 1);
        int offset = s.length();
        for (int i = ids.length - 1; i >= 0; --i) {
            if (i < ids.length - 1) {
                String parentStyleName = s.substring(0, offset);
                ResourceValue val = ResourceValue.referenceTo('\u0000', null, ResourceType.STYLE.getName(), parentStyleName);
                result.add(new MyParentStyleReference(value, new TextRange(1, 1 + offset), val, facet));
                if (ResourceNameConverter.hasExplicitParent(facet, parentStyleName)) break;
            }
            offset = offset - ids[i].length() - 1;
        }
        return result.toArray(new PsiReference[result.size()]);
    }

    public static boolean hasExplicitParent(@NotNull AndroidFacet facet, @NotNull String localStyleName) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/resources/ResourceNameConverter", "hasExplicitParent"));
        }
        if (localStyleName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/dom/resources/ResourceNameConverter", "hasExplicitParent"));
        }
        List<ValueResourceInfoImpl> styles = facet.getLocalResourceManager().findValueResourceInfos(ResourceType.STYLE.getName(), localStyleName, true, false);
        if (styles.size() == 0) {
            return false;
        }
        for (ValueResourceInfoImpl info : styles) {
            ResourceElement domElement = info.computeDomElement();
            if (domElement instanceof Style && ((Style)domElement).getParentStyle().getStringValue() != null) continue;
            return false;
        }
        return true;
    }

    public static class MyParentStyleReference
    extends AndroidResourceReferenceBase
    implements LocalQuickFixProvider {
        public MyParentStyleReference(@NotNull GenericDomValue value, @Nullable TextRange range, @NotNull ResourceValue resourceValue, @NotNull AndroidFacet facet) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/resources/ResourceNameConverter$MyParentStyleReference", "<init>"));
            }
            if (resourceValue == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/dom/resources/ResourceNameConverter$MyParentStyleReference", "<init>"));
            }
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/dom/resources/ResourceNameConverter$MyParentStyleReference", "<init>"));
            }
            super(value, range, resourceValue, facet);
        }

        public LocalQuickFix[] getQuickFixes() {
            String resourceName = this.getValue();
            if (resourceName.length() == 0) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            PsiFile psiFile = ((XmlElement)this.getElement()).getContainingFile();
            if (psiFile == null) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            return new LocalQuickFix[]{new CreateValueResourceQuickFix(this.myFacet, ResourceType.STYLE, resourceName, psiFile, false)};
        }
    }
}

