/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.manifest;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileDescription;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestDomFileDescription
extends DomFileDescription<Manifest> {
    public ManifestDomFileDescription() {
        super(Manifest.class, "manifest", new String[0]);
    }

    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/manifest/ManifestDomFileDescription", "isMyFile"));
        }
        return module == null ? ManifestDomFileDescription.isManifestFile(file) : ManifestDomFileDescription.isManifestFile(file, module);
    }

    public static boolean isManifestFile(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/manifest/ManifestDomFileDescription", "isManifestFile"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return ManifestDomFileDescription.isManifestFile(file, module);
    }

    public static boolean isManifestFile(@NotNull XmlFile file, @Nullable Module module) {
        AndroidFacet facet;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/manifest/ManifestDomFileDescription", "isManifestFile"));
        }
        if (module != null && !module.isDisposed() && (facet = AndroidFacet.getInstance(module)) != null) {
            return ManifestDomFileDescription.isManifestFile(file, facet);
        }
        return file.getName().equals("AndroidManifest.xml");
    }

    public static boolean isManifestFile(@NotNull XmlFile file, @NotNull AndroidFacet facet) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/manifest/ManifestDomFileDescription", "isManifestFile"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/dom/manifest/ManifestDomFileDescription", "isManifestFile"));
        }
        return file.getName().equals("AndroidManifest.xml") || facet.isGradleProject() && IdeaSourceProvider.isManifestFile(facet, file.getVirtualFile());
    }

    public static boolean isManifestFile(@NotNull VirtualFile file, @NotNull AndroidFacet facet) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/manifest/ManifestDomFileDescription", "isManifestFile"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/dom/manifest/ManifestDomFileDescription", "isManifestFile"));
        }
        return file.getName().equals("AndroidManifest.xml") || facet.isGradleProject() && IdeaSourceProvider.isManifestFile(facet, file);
    }

    protected void initializeFileDescription() {
        this.registerNamespacePolicy("android", new String[]{"http://schemas.android.com/apk/res/android"});
    }
}

