/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.manifest;

import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlName;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.ApplicationComponent;
import org.jetbrains.android.dom.manifest.CompatibleScreensScreen;
import org.jetbrains.android.dom.manifest.Instrumentation;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestElement;
import org.jetbrains.android.dom.manifest.ManifestElementWithName;
import org.jetbrains.android.dom.manifest.Provider;
import org.jetbrains.android.dom.manifest.Receiver;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidManifestUtils {
    private AndroidManifestUtils() {
    }

    @Nullable
    public static String getStyleableNameForElement(@NotNull ManifestElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/manifest/AndroidManifestUtils", "getStyleableNameForElement"));
        }
        if (element instanceof CompatibleScreensScreen) {
            return "AndroidManifestCompatibleScreensScreen";
        }
        return null;
    }

    @NotNull
    public static String getStyleableNameByTagName(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/manifest/AndroidManifestUtils", "getStyleableNameByTagName"));
        }
        String prefix = "AndroidManifest";
        if (tagName.equals("manifest")) {
            String string = prefix;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/manifest/AndroidManifestUtils", "getStyleableNameByTagName"));
            }
            return string;
        }
        String[] parts = tagName.split("-");
        StringBuilder builder = new StringBuilder(prefix);
        for (String part : parts) {
            char first = part.charAt(0);
            String remained = part.substring(1);
            builder.append(Character.toUpperCase(first)).append(remained);
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/manifest/AndroidManifestUtils", "getStyleableNameByTagName"));
        }
        return string;
    }

    @NotNull
    public static String[] getStaticallyDefinedAttrs(@NotNull ManifestElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/manifest/AndroidManifestUtils", "getStaticallyDefinedAttrs"));
        }
        ArrayList<String> strings = new ArrayList<String>();
        if (element instanceof ManifestElementWithName) {
            strings.add("name");
        }
        if (element instanceof ApplicationComponent || element instanceof Application) {
            strings.add("label");
        }
        if (element instanceof Application) {
            strings.add("name");
            strings.add("manageSpaceActivity");
            strings.add("backupAgent");
            strings.add("debuggable");
        }
        if (element instanceof Provider) {
            strings.add("authorities");
        }
        if (element instanceof Instrumentation) {
            strings.add("targetPackage");
        } else if (element instanceof UsesSdk) {
            strings.add("minSdkVersion");
            strings.add("targetSdkVersion");
            strings.add("maxSdkVersion");
        }
        String[] stringArray = ArrayUtil.toStringArray(strings);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/manifest/AndroidManifestUtils", "getStaticallyDefinedAttrs"));
        }
        return stringArray;
    }

    @NotNull
    public static String[] getStaticallyDefinedSubtags(@NotNull ManifestElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/manifest/AndroidManifestUtils", "getStaticallyDefinedSubtags"));
        }
        ArrayList<String> strings = new ArrayList<String>();
        if (element instanceof Manifest) {
            Collections.addAll(strings, "application", "instrumentation", "permission", "permission-group", "permission-tree", "uses-permission", "compatible-screens", "uses-sdk", "uses-feature");
        } else if (element instanceof Application) {
            Collections.addAll(strings, "activity", "activity-alias", "service", "provider", "receiver", "uses-library", "meta-data");
        } else if (element instanceof Activity || element instanceof ActivityAlias || element instanceof Receiver || element instanceof Service) {
            Collections.addAll(strings, "intent-filter", "meta-data");
        } else if (element instanceof Provider) {
            Collections.addAll(strings, "meta-data");
        } else if (element instanceof IntentFilter) {
            strings.add("action");
            strings.add("category");
        }
        String[] stringArray = ArrayUtil.toStringArray(strings);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/manifest/AndroidManifestUtils", "getStaticallyDefinedSubtags"));
        }
        return stringArray;
    }

    @Nullable
    public static String getTagNameByStyleableName(@NotNull String styleableName) {
        if (styleableName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/manifest/AndroidManifestUtils", "getTagNameByStyleableName"));
        }
        String prefix = "AndroidManifest";
        if (!styleableName.startsWith(prefix)) {
            return null;
        }
        String remained = styleableName.substring(prefix.length());
        if (remained.length() == 0) {
            return "manifest";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < remained.length(); ++i) {
            char c = remained.charAt(i);
            if (builder.length() > 0 && Character.isUpperCase(c)) {
                builder.append('-');
            }
            builder.append(Character.toLowerCase(c));
        }
        return builder.toString();
    }

    public static boolean isRequiredAttribute(XmlName attrName, DomElement element) {
        if (element instanceof CompatibleScreensScreen && "http://schemas.android.com/apk/res/android".equals(attrName.getNamespaceKey())) {
            String localName = attrName.getLocalName();
            return "screenSize".equals(localName) || "screenDensity".equals(localName);
        }
        return false;
    }
}

