/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.layout;

import com.android.resources.ResourceType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.annotations.NotNull;

public class LayoutDomFileDescription<T extends LayoutElement>
extends AndroidResourceDomFileDescription<T> {
    public LayoutDomFileDescription(@NotNull Class<T> rootElementClass, @NotNull String rootTagName) {
        if (rootElementClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/layout/LayoutDomFileDescription", "<init>"));
        }
        if (rootTagName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/dom/layout/LayoutDomFileDescription", "<init>"));
        }
        super(rootElementClass, rootTagName, ResourceType.LAYOUT.getName());
    }

    public boolean acceptsOtherRootTagNames() {
        return true;
    }

    public static boolean isLayoutFile(final @NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/layout/LayoutDomFileDescription", "isLayoutFile"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return AndroidResourceDomFileDescription.doIsMyFile(file, new String[]{ResourceType.LAYOUT.getName()});
            }
        });
    }
}

