/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.drawable;

import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.google.common.collect.Lists;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidDrawableDomUtil {
    public static final Map<String, String> SPECIAL_STYLEABLE_NAMES = new HashMap();
    private static final String[] DRAWABLE_ROOTS_V1 = new String[]{"selector", "bitmap", "nine-patch", "layer-list", "level-list", "transition", "inset", "clip", "scale", "shape", "animation-list", "animated-rotate", "rotate"};
    private static final String[] DRAWABLE_ROOTS_V20 = new String[]{"ripple", "animated-selector"};

    private AndroidDrawableDomUtil() {
    }

    public static boolean isDrawableResourceFile(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/drawable/AndroidDrawableDomUtil", "isDrawableResourceFile"));
        }
        return AndroidResourceDomFileDescription.doIsMyFile(file, new String[]{ResourceType.DRAWABLE.getName()});
    }

    public static List<String> getPossibleRoots(AndroidFacet facet) {
        AndroidVersion sdkVersion = AndroidModuleInfo.get(facet).getBuildSdkVersion();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)(DRAWABLE_ROOTS_V1.length + DRAWABLE_ROOTS_V20.length));
        Collections.addAll(result, DRAWABLE_ROOTS_V1);
        if (sdkVersion == null || sdkVersion.getFeatureLevel() >= 21) {
            Collections.addAll(result, DRAWABLE_ROOTS_V20);
        }
        return result;
    }

    static {
        SPECIAL_STYLEABLE_NAMES.put("selector", "StateListDrawable");
        SPECIAL_STYLEABLE_NAMES.put("bitmap", "BitmapDrawable");
        SPECIAL_STYLEABLE_NAMES.put("nine-patch", "NinePatchDrawable");
        SPECIAL_STYLEABLE_NAMES.put("layer-list", "LayerDrawable");
        SPECIAL_STYLEABLE_NAMES.put("inset", "InsetDrawable");
        SPECIAL_STYLEABLE_NAMES.put("clip", "ClipDrawable");
        SPECIAL_STYLEABLE_NAMES.put("scale", "ScaleDrawable");
        SPECIAL_STYLEABLE_NAMES.put("animation-list", "AnimationDrawable");
        SPECIAL_STYLEABLE_NAMES.put("rotate", "RotateDrawable");
        SPECIAL_STYLEABLE_NAMES.put("animated-rotate", "AnimatedRotateDrawable");
        SPECIAL_STYLEABLE_NAMES.put("ripple", "RippleDrawable");
        SPECIAL_STYLEABLE_NAMES.put("animated-selector", "AnimatedStateListDrawable");
        SPECIAL_STYLEABLE_NAMES.put("shape", "GradientDrawable");
        SPECIAL_STYLEABLE_NAMES.put("corners", "DrawableCorners");
        SPECIAL_STYLEABLE_NAMES.put("gradient", "GradientDrawableGradient");
        SPECIAL_STYLEABLE_NAMES.put("padding", "GradientDrawablePadding");
        SPECIAL_STYLEABLE_NAMES.put("size", "GradientDrawableSize");
        SPECIAL_STYLEABLE_NAMES.put("solid", "GradientDrawableSolid");
        SPECIAL_STYLEABLE_NAMES.put("stroke", "GradientDrawableStroke");
    }
}

