/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.psi.PsiElement;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.resources.StyleItem;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleItemConverter
extends WrappingConverter {
    @Nullable
    private static ResolvingConverter findConverterForAttribute(String nsPrefix, String localName, @NotNull AndroidFacet facet, @NotNull GenericDomValue element) {
        AttributeDefinition attr;
        AttributeDefinitions attrDefs;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/dom/converters/StyleItemConverter", "findConverterForAttribute"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/dom/converters/StyleItemConverter", "findConverterForAttribute"));
        }
        ResourceManager manager = facet.getResourceManager("android".equals(nsPrefix) ? "android" : null, (PsiElement)element.getXmlElement());
        if (manager != null && (attrDefs = manager.getAttributeDefinitions()) != null && (attr = attrDefs.getAttrDefByName(localName)) != null) {
            return AndroidDomUtil.getConverter(attr);
        }
        return null;
    }

    public Converter getConverter(@NotNull GenericDomValue element) {
        AndroidFacet facet;
        String[] strs;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/converters/StyleItemConverter", "getConverter"));
        }
        StyleItem item = (StyleItem)element;
        String name = (String)item.getName().getValue();
        if (name != null && ((strs = name.split(":")).length == 1 || strs.length == 2) && (facet = AndroidFacet.getInstance((DomElement)element)) != null) {
            String namespacePrefix = strs.length == 2 ? strs[0] : null;
            String localName = strs[strs.length - 1];
            return StyleItemConverter.findConverterForAttribute(namespacePrefix, localName, facet, element);
        }
        return null;
    }
}

