/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeConverter
extends ResolvingConverter<String> {
    private final List<ResolvingConverter<String>> converters = new ArrayList<ResolvingConverter<String>>();

    public void addConverter(@NotNull ResolvingConverter<String> converter) {
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/converters/CompositeConverter", "addConverter"));
        }
        this.converters.add(converter);
    }

    @NotNull
    public List<ResolvingConverter<String>> getConverters() {
        List<ResolvingConverter<String>> list = this.converters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/CompositeConverter", "getConverters"));
        }
        return list;
    }

    public int size() {
        return this.converters.size();
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        ArrayList<String> variants = new ArrayList<String>();
        for (ResolvingConverter<String> converter : this.converters) {
            variants.addAll(converter.getVariants(context));
        }
        ArrayList<String> arrayList = variants;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/CompositeConverter", "getVariants"));
        }
        return arrayList;
    }

    public String fromString(@Nullable String s, ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }
}

