/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.res2.ResourceItem;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceReferenceBase
extends PsiReferenceBase.Poly<XmlElement> {
    protected final AndroidFacet myFacet;
    protected final ResourceValue myResourceValue;

    public AndroidResourceReferenceBase(@NotNull GenericDomValue value, @Nullable TextRange range, @NotNull ResourceValue resourceValue, @NotNull AndroidFacet facet) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/converters/AndroidResourceReferenceBase", "<init>"));
        }
        if (resourceValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/dom/converters/AndroidResourceReferenceBase", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/dom/converters/AndroidResourceReferenceBase", "<init>"));
        }
        super((PsiElement)DomUtil.getValueElement((GenericDomValue)value), range, true);
        this.myResourceValue = resourceValue;
        this.myFacet = facet;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/converters/AndroidResourceReferenceBase", "bindToElement"));
        }
        return null;
    }

    @NotNull
    public ResourceValue getResourceValue() {
        ResourceValue resourceValue = this.myResourceValue;
        if (resourceValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/AndroidResourceReferenceBase", "getResourceValue"));
        }
        return resourceValue;
    }

    @NotNull
    public PsiElement[] computeTargetElements() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        ArrayList<PsiElement> results = new ArrayList<PsiElement>();
        for (ResolveResult result : resolveResults) {
            PsiElement element = result.getElement();
            if (element instanceof LazyValueResourceElementWrapper) {
                element = ((LazyValueResourceElementWrapper)element).computeElement();
            }
            if (element instanceof ResourceElementWrapper) {
                element = ((ResourceElementWrapper)element).getWrappee();
            }
            if (element == null) continue;
            results.add(element);
        }
        PsiElement[] psiElementArray = results.toArray(new PsiElement[results.size()]);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/AndroidResourceReferenceBase", "computeTargetElements"));
        }
        return psiElementArray;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)((XmlElement)this.myElement).getProject()).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)new ResolveCache.PolyVariantResolver<AndroidResourceReferenceBase>(){

            @NotNull
            public ResolveResult[] resolve(@NotNull AndroidResourceReferenceBase reference, boolean incompleteCode) {
                if (reference == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/converters/AndroidResourceReferenceBase$1", "resolve"));
                }
                ResolveResult[] resolveResultArray = AndroidResourceReferenceBase.this.resolveInner();
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/AndroidResourceReferenceBase$1", "resolve"));
                }
                return resolveResultArray;
            }
        }, false, incompleteCode);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/AndroidResourceReferenceBase", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    private ResolveResult[] resolveInner() {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        boolean attrReference = this.myResourceValue.getPrefix() == '?';
        this.collectTargets(this.myFacet, this.myResourceValue, elements, attrReference);
        ArrayList<PsiElementResolveResult> result = new ArrayList<PsiElementResolveResult>();
        if (elements.isEmpty() && this.myResourceValue.getResourceName() != null) {
            AppResourceRepository resources = AppResourceRepository.getAppResources(this.myFacet.getModule(), true);
            ResourceType resourceType = this.myResourceValue.getType();
            if (resourceType != null && (resourceType != ResourceType.ATTR || attrReference)) {
                assert (resources != null);
                List items = resources.getResourceItem(resourceType, this.myResourceValue.getResourceName());
                if (items != null && FolderTypeRelationship.getRelatedFolders((ResourceType)resourceType).contains(ResourceFolderType.VALUES)) {
                    for (ResourceItem item : items) {
                        XmlTag tag = LocalResourceRepository.getItemTag(this.myFacet.getModule().getProject(), item);
                        if (tag == null) continue;
                        elements.add((PsiElement)tag);
                    }
                }
            }
        }
        if (elements.size() > 1) {
            Collections.sort(elements, AndroidResourceUtil.RESOURCE_ELEMENT_COMPARATOR);
        }
        for (PsiElement target : elements) {
            result.add(new PsiElementResolveResult(target));
        }
        ResolveResult[] resolveResultArray = result.toArray(new ResolveResult[result.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/AndroidResourceReferenceBase", "resolveInner"));
        }
        return resolveResultArray;
    }

    private void collectTargets(AndroidFacet facet, ResourceValue resValue, List<PsiElement> elements, boolean attrReference) {
        String resName;
        ResourceType resType = resValue.getType();
        if (resType == null) {
            return;
        }
        ResourceManager manager = facet.getResourceManager(resValue.getPackage(), this.myElement);
        if (manager != null && (resName = resValue.getResourceName()) != null) {
            manager.collectLazyResourceElements(resType.getName(), resName, attrReference, this.myElement, elements);
        }
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof LazyValueResourceElementWrapper && (element = ((LazyValueResourceElementWrapper)element).computeElement()) == null) {
            return false;
        }
        ResolveResult[] results = this.multiResolve(false);
        PsiFile psiFile = element.getContainingFile();
        VirtualFile vFile = psiFile != null ? psiFile.getVirtualFile() : null;
        for (ResolveResult result : results) {
            ValueResourceInfo info;
            PsiElement target = result.getElement();
            if (element.getManager().areElementsEquivalent(target, element)) {
                return true;
            }
            if (!(target instanceof LazyValueResourceElementWrapper) || vFile == null || !(info = ((LazyValueResourceElementWrapper)target).getResourceInfo()).getContainingFile().equals(vFile)) continue;
            XmlAttributeValue realTarget = info.computeXmlElement();
            if (!element.getManager().areElementsEquivalent((PsiElement)realTarget, element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/AndroidResourceReferenceBase", "getVariants"));
        }
        return EMPTY_ARRAY;
    }
}

