/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.converter;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectConverter;
import org.jetbrains.annotations.NotNull;

public class AndroidModuleToJavaModuleConverterProvider
extends ConverterProvider {
    public AndroidModuleToJavaModuleConverterProvider() {
        super("android-module-to-java-module");
    }

    @NotNull
    public String getConversionDescription() {
        if ("Android modules will be converted to Java modules with Android facet" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/converter/AndroidModuleToJavaModuleConverterProvider", "getConversionDescription"));
        }
        return "Android modules will be converted to Java modules with Android facet";
    }

    @NotNull
    public ProjectConverter createConverter(@NotNull ConversionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/converter/AndroidModuleToJavaModuleConverterProvider", "createConverter"));
        }
        ProjectConverter projectConverter = new ProjectConverter(){

            public ConversionProcessor<ModuleSettings> createModuleFileConverter() {
                return new ConversionProcessor<ModuleSettings>(){

                    public boolean isConversionNeeded(ModuleSettings moduleSettings) {
                        return "ANDROID_MODULE".equals(moduleSettings.getModuleType());
                    }

                    public void process(ModuleSettings moduleSettings) throws CannotConvertException {
                        moduleSettings.setModuleType("JAVA_MODULE");
                    }
                };
            }
        };
        if (projectConverter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/converter/AndroidModuleToJavaModuleConverterProvider", "createConverter"));
        }
        return projectConverter;
    }
}

