/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.fileTypes.AndroidRenderscriptFileType;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.GeneratingCompiler;
import com.intellij.openapi.compiler.SourceGeneratingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.tools.AndroidRenderscript;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRenderscriptCompiler
implements SourceGeneratingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidRenderscriptCompiler");
    private static final GeneratingCompiler.GenerationItem[] EMPTY_GENERATION_ITEM_ARRAY = new GeneratingCompiler.GenerationItem[0];

    @Nullable
    public VirtualFile getPresentableFile(CompileContext context, Module module, VirtualFile outputRoot, VirtualFile generatedFile) {
        return null;
    }

    public GeneratingCompiler.GenerationItem[] getGenerationItems(final CompileContext context) {
        return (GeneratingCompiler.GenerationItem[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<GeneratingCompiler.GenerationItem[]>(){

            public GeneratingCompiler.GenerationItem[] compute() {
                if (context.getProject().isDisposed()) {
                    return EMPTY_GENERATION_ITEM_ARRAY;
                }
                VirtualFile[] files = context.getProjectCompileScope().getFiles((FileType)AndroidRenderscriptFileType.INSTANCE, true);
                HashMap module2files = new HashMap();
                for (VirtualFile file : files) {
                    Module module = context.getModuleByFile(file);
                    if (module == null) continue;
                    ArrayList<VirtualFile> filesForModule = (ArrayList<VirtualFile>)module2files.get(module);
                    if (filesForModule == null) {
                        filesForModule = new ArrayList<VirtualFile>();
                        module2files.put(module, filesForModule);
                    }
                    filesForModule.add(file);
                }
                ArrayList items = new ArrayList(files.length);
                for (Map.Entry entry : module2files.entrySet()) {
                    Module module = (Module)entry.getKey();
                    AndroidFacet facet = (AndroidFacet)FacetManager.getInstance((Module)module).getFacetByType(AndroidFacet.ID);
                    if (facet == null) continue;
                    AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
                    if (platform == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.specify.platform", module.getName()), null, -1, -1);
                        continue;
                    }
                    IAndroidTarget target = platform.getTarget();
                    String sdkLocation = platform.getSdkData().getPath();
                    String resourceDirPath = AndroidRootUtil.getResourceDirPath(facet);
                    assert (resourceDirPath != null);
                    AndroidRenderscriptCompiler.addItem((Collection)entry.getValue(), facet, resourceDirPath, sdkLocation, target, items);
                }
                return items.toArray(new GeneratingCompiler.GenerationItem[items.size()]);
            }
        });
    }

    private static void addItem(@NotNull Collection<VirtualFile> sourceFiles, @NotNull AndroidFacet facet, @NotNull String resourceDirPath, @NotNull String sdkLocation, @NotNull IAndroidTarget target, @NotNull List<GeneratingCompiler.GenerationItem> items) {
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler", "addItem"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler", "addItem"));
        }
        if (resourceDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler", "addItem"));
        }
        if (sdkLocation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler", "addItem"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler", "addItem"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler", "addItem"));
        }
        String sourceRootPath = AndroidRootUtil.getRenderscriptGenSourceRootPath(facet);
        if (sourceRootPath == null) {
            return;
        }
        String rawDirPath = resourceDirPath + '/' + "raw";
        items.add(new MyGenerationItem(facet.getModule(), sourceFiles, rawDirPath, sdkLocation, target));
    }

    public GeneratingCompiler.GenerationItem[] generate(CompileContext context, GeneratingCompiler.GenerationItem[] items, VirtualFile outputRootDirectory) {
        if (items == null || items.length <= 0) {
            return EMPTY_GENERATION_ITEM_ARRAY;
        }
        context.getProgressIndicator().setText("Compiling RenderScript files...");
        GeneratingCompiler.GenerationItem[] generationItems = AndroidRenderscriptCompiler.doGenerate(context, items, outputRootDirectory);
        HashSet generatedVFiles = new HashSet();
        HashSet visited = new HashSet();
        outputRootDirectory.refresh(false, true);
        AndroidUtils.collectFiles(outputRootDirectory, (Set<VirtualFile>)visited, (Set<VirtualFile>)generatedVFiles);
        if (context instanceof CompileContextEx) {
            ((CompileContextEx)context).markGenerated((Collection)generatedVFiles);
        }
        return generationItems;
    }

    @NotNull
    public String getDescription() {
        String string = AndroidBundle.message("android.renderscript.compiler.description", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler", "getDescription"));
        }
        return string;
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    @Nullable
    public ValidityState createValidityState(DataInput in) throws IOException {
        return new MyValidityState(in);
    }

    private static GeneratingCompiler.GenerationItem[] doGenerate(final @NotNull CompileContext context, @NotNull GeneratingCompiler.GenerationItem[] items, VirtualFile outputRootDirectory) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler", "doGenerate"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler", "doGenerate"));
        }
        if (context.getProject().isDisposed()) {
            return EMPTY_GENERATION_ITEM_ARRAY;
        }
        String genRootPath = FileUtil.toSystemDependentName((String)outputRootDirectory.getPath());
        File genRootDir = new File(genRootPath);
        if (genRootDir.exists()) {
            if (!FileUtil.delete((File)genRootDir)) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot delete directory " + genRootPath, null, -1, -1);
                return EMPTY_GENERATION_ITEM_ARRAY;
            }
            if (!genRootDir.mkdir()) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot create directory " + genRootPath, null, -1, -1);
                return EMPTY_GENERATION_ITEM_ARRAY;
            }
        }
        ArrayList<MyGenerationItem> results = new ArrayList<MyGenerationItem>(items.length);
        for (GeneratingCompiler.GenerationItem item : items) {
            if (!(item instanceof MyGenerationItem)) continue;
            MyGenerationItem genItem = (MyGenerationItem)item;
            if (!AndroidCompileUtil.isModuleAffected(context, genItem.myModule)) continue;
            boolean success = true;
            for (final VirtualFile sourceFile : genItem.myFiles) {
                String depFolderOsPath = AndroidRenderscriptCompiler.getDependencyFolder(context.getProject(), sourceFile, outputRootDirectory);
                try {
                    final Map messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidRenderscript.execute((String)genItem.mySdkLocation, (IAndroidTarget)genItem.myAndroidTarget, (String)sourceFile.getPath(), (String)genRootPath, (String)depFolderOsPath, (String)genItem.myRawDirPath));
                    AndroidCompileUtil.markDirty(outputRootDirectory, true);
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            if (context.getProject().isDisposed()) {
                                return;
                            }
                            AndroidRenderscriptCompiler.addMessages(context, messages, sourceFile.getUrl());
                        }
                    });
                    if (((List)messages.get(CompilerMessageCategory.ERROR)).size() <= 0) continue;
                    success = false;
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            if (context.getProject().isDisposed()) {
                                return;
                            }
                            context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), sourceFile.getUrl(), -1, -1);
                        }
                    });
                    success = false;
                }
            }
            if (!success) continue;
            results.add(genItem);
        }
        outputRootDirectory.refresh(false, true);
        return results.toArray(new GeneratingCompiler.GenerationItem[results.size()]);
    }

    private static void addMessages(@NotNull CompileContext context, @NotNull Map<CompilerMessageCategory, List<String>> messages, @NotNull String url) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler", "addMessages"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler", "addMessages"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler", "addMessages"));
        }
        for (CompilerMessageCategory category : messages.keySet()) {
            List<String> messageList = messages.get(category);
            for (String message : messageList) {
                context.addMessage(category, message, url, -1, -1);
            }
        }
    }

    @Nullable
    static String getDependencyFolder(@NotNull Project project, @NotNull VirtualFile sourceFile, @NotNull VirtualFile genFolder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler", "getDependencyFolder"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler", "getDependencyFolder"));
        }
        if (genFolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler", "getDependencyFolder"));
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile sourceRoot = index.getSourceRootForFile(sourceFile);
        if (sourceRoot == null) {
            return null;
        }
        VirtualFile parent = sourceFile.getParent();
        if (Comparing.equal((Object)parent, (Object)sourceRoot)) {
            return genFolder.getPath();
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)sourceFile.getParent(), (VirtualFile)sourceRoot, (char)'/');
        assert (relativePath != null);
        return genFolder.getPath() + '/' + relativePath;
    }

    private static class MyValidityState
    implements ValidityState {
        private final Map<String, Long> myTimestamps;

        MyValidityState(DataInput in) throws IOException {
            this.myTimestamps = new HashMap();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String path = in.readUTF();
                long timestamp = in.readLong();
                this.myTimestamps.put(path, timestamp);
            }
        }

        MyValidityState(@NotNull Collection<VirtualFile> files) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler$MyValidityState", "<init>"));
            }
            this.myTimestamps = new HashMap();
            for (VirtualFile file : files) {
                this.myTimestamps.put(file.getPath(), file.getTimeStamp());
            }
        }

        public boolean equalsTo(ValidityState otherState) {
            if (!(otherState instanceof MyValidityState)) {
                return false;
            }
            return ((Object)((MyValidityState)otherState).myTimestamps).equals(this.myTimestamps);
        }

        public void save(DataOutput out) throws IOException {
            out.writeInt(this.myTimestamps.size());
            for (Map.Entry<String, Long> entry : this.myTimestamps.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeLong(entry.getValue());
            }
        }
    }

    private static class MyGenerationItem
    implements GeneratingCompiler.GenerationItem {
        final Module myModule;
        final String mySdkLocation;
        final Collection<VirtualFile> myFiles;
        final IAndroidTarget myAndroidTarget;
        final String myRawDirPath;
        private final MyValidityState myValidityState;

        public MyGenerationItem(@NotNull Module module, @NotNull Collection<VirtualFile> files, @NotNull String rawDirPath, @NotNull String sdkLocation, @NotNull IAndroidTarget target) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler$MyGenerationItem", "<init>"));
            }
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler$MyGenerationItem", "<init>"));
            }
            if (rawDirPath == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler$MyGenerationItem", "<init>"));
            }
            if (sdkLocation == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler$MyGenerationItem", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/android/compiler/AndroidRenderscriptCompiler$MyGenerationItem", "<init>"));
            }
            this.myModule = module;
            this.myFiles = files;
            this.myRawDirPath = rawDirPath;
            this.mySdkLocation = sdkLocation;
            this.myAndroidTarget = target;
            this.myValidityState = new MyValidityState(this.myFiles);
        }

        @Nullable
        public String getPath() {
            return "";
        }

        @Nullable
        public ValidityState getValidityState() {
            return this.myValidityState;
        }

        public Module getModule() {
            return this.myModule;
        }

        public boolean isTestSource() {
            return false;
        }
    }
}

