/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.intellij.compiler.CompilerIOUtil;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.PackagingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidDexCompiler;
import org.jetbrains.android.compiler.AndroidResourcesPackagingCompiler;
import org.jetbrains.android.compiler.ExcludedSourcesFilter;
import org.jetbrains.android.compiler.tools.AndroidApkBuilder;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidNativeLibData;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPackagingCompiler
implements PackagingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidPackagingCompiler");

    public void processOutdatedItem(CompileContext context, String url, @Nullable ValidityState state) {
    }

    @NotNull
    private static VirtualFile[] getExternalJars(@NotNull Module module, @NotNull AndroidFacetConfiguration configuration) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidPackagingCompiler", "getExternalJars"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidPackagingCompiler", "getExternalJars"));
        }
        AndroidPlatform platform = configuration.getAndroidPlatform();
        if (platform != null) {
            List<VirtualFile> externalLibsAndModules = AndroidRootUtil.getExternalLibraries(module);
            VirtualFile[] virtualFileArray = externalLibsAndModules.toArray(new VirtualFile[externalLibsAndModules.size()]);
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPackagingCompiler", "getExternalJars"));
            }
            return virtualFileArray;
        }
        if (VirtualFile.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPackagingCompiler", "getExternalJars"));
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    private static void fillSourceRoots(@NotNull Module module, @NotNull Set<Module> visited, @NotNull Set<VirtualFile> result, boolean includingTests) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidPackagingCompiler", "fillSourceRoots"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidPackagingCompiler", "fillSourceRoots"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidPackagingCompiler", "fillSourceRoots"));
        }
        visited.add(module);
        AndroidFacet facet = AndroidFacet.getInstance(module);
        VirtualFile resDir = facet != null ? AndroidRootUtil.getResourceDir(facet) : null;
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile virtualFile : manager.getSourceRoots(includingTests)) {
            if (Comparing.equal((Object)resDir, (Object)virtualFile)) continue;
            result.add(virtualFile);
        }
        for (VirtualFile virtualFile : manager.getOrderEntries()) {
            Module depModule;
            ModuleOrderEntry moduleOrderEntry;
            DependencyScope scope;
            if (!(virtualFile instanceof ModuleOrderEntry) || (scope = (moduleOrderEntry = (ModuleOrderEntry)virtualFile).getScope()) != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || visited.contains(depModule)) continue;
            AndroidPackagingCompiler.fillSourceRoots(depModule, visited, result, false);
        }
    }

    @NotNull
    public static VirtualFile[] getSourceRootsForModuleAndDependencies(@NotNull Module module, boolean includingTests) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidPackagingCompiler", "getSourceRootsForModuleAndDependencies"));
        }
        HashSet result = new HashSet();
        AndroidPackagingCompiler.fillSourceRoots(module, (Set<Module>)new HashSet(), (Set<VirtualFile>)result, includingTests);
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray((Collection)result);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPackagingCompiler", "getSourceRootsForModuleAndDependencies"));
        }
        return virtualFileArray;
    }

    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(CompileContext context) {
        ArrayList<AptPackagingItem> items = new ArrayList<AptPackagingItem>();
        for (Module module : ModuleManager.getInstance((Project)context.getProject()).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || facet.isLibraryProject()) continue;
            VirtualFile manifestFile = AndroidRootUtil.getManifestFileForCompiler(facet);
            VirtualFile[] sourceRoots = AndroidPackagingCompiler.getSourceRootsForModuleAndDependencies(module, facet.getProperties().PACK_TEST_CODE);
            if (manifestFile == null) continue;
            AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
            VirtualFile outputDir = AndroidDexCompiler.getOutputDirectoryForDex(module);
            if (outputDir == null) continue;
            VirtualFile[] externalJars = AndroidPackagingCompiler.getExternalJars(module, configuration);
            File resPackage = AndroidResourcesPackagingCompiler.getOutputFile(module, outputDir);
            String resPackagePath = FileUtil.toSystemDependentName((String)resPackage.getPath());
            File classesDexFile = new File(outputDir.getPath(), "classes.dex");
            String classesDexPath = FileUtil.toSystemDependentName((String)classesDexFile.getPath());
            AndroidPlatform platform = configuration.getAndroidPlatform();
            if (platform == null) {
                context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.specify.platform", module.getName()), null, -1, -1);
                continue;
            }
            String sdkPath = platform.getSdkData().getPath();
            String outputPath = AndroidRootUtil.getApkPath(facet);
            if (outputPath == null) {
                context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.apk.path.not.specified", module.getName()), null, -1, -1);
                continue;
            }
            String keystorePath = FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)configuration.getState().CUSTOM_DEBUG_KEYSTORE_PATH));
            items.add(AndroidPackagingCompiler.createItem(module, facet, manifestFile, sourceRoots, externalJars, resPackagePath, classesDexPath, sdkPath, outputPath, false, AndroidCompileUtil.isReleaseBuild(context), keystorePath));
        }
        FileProcessingCompiler.ProcessingItem[] processingItemArray = items.toArray(new FileProcessingCompiler.ProcessingItem[items.size()]);
        if (processingItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPackagingCompiler", "getProcessingItems"));
        }
        return processingItemArray;
    }

    private static AptPackagingItem createItem(Module module, AndroidFacet facet, VirtualFile manifestFile, VirtualFile[] sourceRoots, VirtualFile[] externalJars, String resPackagePath, String classesDexPath, String sdkPath, String outputPath, boolean generateSignedApk, boolean releaseBuild, String customKeystorePath) {
        AptPackagingItem item = new AptPackagingItem(sdkPath, manifestFile, resPackagePath, outputPath, generateSignedApk, releaseBuild, module, customKeystorePath, ((AndroidFacetConfiguration)facet.getConfiguration()).getAdditionalNativeLibraries());
        item.setNativeLibsFolders(AndroidPackagingCompiler.collectNativeLibsFolders(facet));
        item.setClassesDexPath(classesDexPath);
        item.setSourceRoots(sourceRoots);
        item.setExternalLibraries(externalJars);
        return item;
    }

    @NotNull
    private static VirtualFile[] collectNativeLibsFolders(AndroidFacet facet) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VirtualFile libsDir = AndroidRootUtil.getLibsDir(facet);
        if (libsDir != null) {
            result.add(libsDir);
        }
        for (AndroidFacet depFacet : AndroidUtils.getAndroidLibraryDependencies(facet.getModule())) {
            VirtualFile depLibsDir = AndroidRootUtil.getLibsDir(depFacet);
            if (depLibsDir == null) continue;
            result.add(depLibsDir);
        }
        VirtualFile[] virtualFileArray = result.toArray(new VirtualFile[result.size()]);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPackagingCompiler", "collectNativeLibsFolders"));
        }
        return virtualFileArray;
    }

    private static String[] getPaths(@NotNull VirtualFile[] vFiles) {
        if (vFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidPackagingCompiler", "getPaths"));
        }
        String[] result = new String[vFiles.length];
        for (int i = 0; i < vFiles.length; ++i) {
            VirtualFile vFile = vFiles[i];
            result[i] = FileUtil.toSystemDependentName((String)vFile.getPath());
        }
        return result;
    }

    public FileProcessingCompiler.ProcessingItem[] process(CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
        if (!AndroidCompileUtil.isFullBuild(context)) {
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        context.getProgressIndicator().setText("Building Android package...");
        ArrayList<AptPackagingItem> result = new ArrayList<AptPackagingItem>();
        for (FileProcessingCompiler.ProcessingItem processingItem : items) {
            AptPackagingItem item = (AptPackagingItem)processingItem;
            if (!AndroidCompileUtil.isModuleAffected(context, item.myModule)) continue;
            AndroidPackagingCompiler.doProcess(context, item, false);
            if (context.getMessages(CompilerMessageCategory.ERROR).length == 0) {
                AndroidPackagingCompiler.doProcess(context, item, true);
            }
            if (context.getMessages(CompilerMessageCategory.ERROR).length != 0) continue;
            result.add(item);
        }
        return result.toArray(new FileProcessingCompiler.ProcessingItem[result.size()]);
    }

    private static void doProcess(final CompileContext context, AptPackagingItem item, boolean unsigned) {
        if (!AndroidPackagingCompiler.shouldGenerateApk(item.myModule, context, unsigned)) {
            return;
        }
        try {
            String[] externalLibPaths = AndroidPackagingCompiler.getPaths(item.getExternalLibraries());
            String resPackagePath = unsigned ? item.getResPackagePath() + ".release" : item.getResPackagePath();
            String finalPath = unsigned ? AndroidCommonUtils.addSuffixToFileName((String)item.getFinalPath(), (String)".unsigned") : item.getFinalPath();
            String[] sourceRoots = AndroidCompileUtil.toOsPaths(item.getSourceRoots());
            String[] nativeLibsFolders = AndroidCompileUtil.toOsPaths(item.getNativeLibsFolders());
            Project project = context.getProject();
            Map<CompilerMessageCategory, List<String>> messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidApkBuilder.execute((String)resPackagePath, (String)item.getClassesDexPath(), (String[])sourceRoots, (String[])externalLibPaths, (String[])nativeLibsFolders, item.getAdditionalNativeLibs(), (String)finalPath, (boolean)unsigned, (String)item.mySdkPath, (String)item.getCustomKeystorePath(), (Condition)new ExcludedSourcesFilter(project)));
            if (((List)messages.get(CompilerMessageCategory.ERROR)).size() == 0 && item.myReleaseBuild == unsigned) {
                File dst = new File(AndroidCommonUtils.addSuffixToFileName((String)item.getFinalPath(), (String)".afp"));
                FileUtil.copy((File)new File(finalPath), (File)dst);
                CompilerUtil.refreshIOFile((File)dst);
                VirtualFile jar = JarFileSystem.getInstance().refreshAndFindFileByPath(dst.getPath() + "!/");
                if (jar != null) {
                    jar.refresh(false, true);
                }
            }
            AndroidCompileUtil.addMessages(context, messages, item.myModule);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (context.getProject().isDisposed()) {
                        return;
                    }
                    context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                }
            });
        }
    }

    public static boolean shouldGenerateApk(Module module, CompileContext context, boolean unsigned) {
        boolean releaseBuild = AndroidCompileUtil.isReleaseBuild(context);
        if (!unsigned) {
            return !releaseBuild;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return true;
        }
        return releaseBuild;
    }

    @NotNull
    public String getDescription() {
        if ("Android Packaging Compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPackagingCompiler", "getDescription"));
        }
        return "Android Packaging Compiler";
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput is) throws IOException {
        return new MyValidityState(is);
    }

    private static class MyValidityState
    implements ValidityState {
        private final Map<String, Long> myResourceTimestamps = new HashMap<String, Long>();
        private final Map<AndroidNativeLibData, Long> myAdditionalNativeLibs = new HashMap<AndroidNativeLibData, Long>();
        private final String myApkPath;
        private final boolean myGenerateUnsignedApk;
        private final boolean myReleaseBuild;
        private final String myCustomKeystorePath;

        MyValidityState(DataInput is) throws IOException {
            int i;
            int size = is.readInt();
            for (i = 0; i < size; ++i) {
                String key = is.readUTF();
                long value = is.readLong();
                this.myResourceTimestamps.put(key, value);
            }
            this.myGenerateUnsignedApk = is.readBoolean();
            this.myReleaseBuild = is.readBoolean();
            this.myApkPath = is.readUTF();
            this.myCustomKeystorePath = CompilerIOUtil.readString((DataInput)is);
            size = is.readInt();
            for (i = 0; i < size; ++i) {
                String architecture = is.readUTF();
                String path = is.readUTF();
                String targetFileName = is.readUTF();
                long timestamp = is.readLong();
                this.myAdditionalNativeLibs.put(new AndroidNativeLibData(architecture, path, targetFileName), timestamp);
            }
        }

        MyValidityState(Project project, String resPackagePath, String classesDexPath, String apkPath, boolean generateUnsignedApk, boolean releaseBuild, VirtualFile[] sourceRoots, VirtualFile[] externalLibs, VirtualFile[] nativeLibFolders, String customKeystorePath, List<AndroidNativeLibData> additionalNativeLibs) {
            this.myResourceTimestamps.put(FileUtil.toSystemIndependentName((String)resPackagePath), new File(resPackagePath).lastModified());
            this.myResourceTimestamps.put(FileUtil.toSystemIndependentName((String)classesDexPath), new File(classesDexPath).lastModified());
            this.myApkPath = apkPath;
            this.myGenerateUnsignedApk = generateUnsignedApk;
            this.myReleaseBuild = releaseBuild;
            this.myCustomKeystorePath = customKeystorePath != null ? customKeystorePath : "";
            HashSet resourcesFromSourceRoot = new HashSet();
            for (VirtualFile sourceRoot : sourceRoots) {
                AndroidApkBuilder.collectStandardJavaResources((File)new File(sourceRoot.getPath()), (Collection)resourcesFromSourceRoot, (Condition)new ExcludedSourcesFilter(project));
            }
            for (File resource : resourcesFromSourceRoot) {
                this.myResourceTimestamps.put(FileUtil.toSystemIndependentName((String)resource.getPath()), resource.lastModified());
            }
            for (VirtualFile externalLib : externalLibs) {
                this.myResourceTimestamps.put(externalLib.getPath(), externalLib.getTimeStamp());
            }
            ArrayList nativeLibs = new ArrayList();
            for (VirtualFile nativeLibFolder : nativeLibFolders) {
                for (VirtualFile child : nativeLibFolder.getChildren()) {
                    AndroidApkBuilder.collectNativeLibraries((File)new File(child.getPath()), nativeLibs, (!releaseBuild ? 1 : 0) != 0);
                }
            }
            for (File nativeLib : nativeLibs) {
                this.myResourceTimestamps.put(FileUtil.toSystemIndependentName((String)nativeLib.getPath()), nativeLib.lastModified());
            }
            for (AndroidNativeLibData lib : additionalNativeLibs) {
                String path = lib.getPath();
                this.myAdditionalNativeLibs.put(lib, new File(path).lastModified());
            }
        }

        public boolean equalsTo(ValidityState otherState) {
            if (!(otherState instanceof MyValidityState)) {
                return false;
            }
            MyValidityState mvs = (MyValidityState)otherState;
            return mvs.myGenerateUnsignedApk == this.myGenerateUnsignedApk && mvs.myReleaseBuild == this.myReleaseBuild && ((Object)mvs.myResourceTimestamps).equals(this.myResourceTimestamps) && mvs.myApkPath.equals(this.myApkPath) && mvs.myCustomKeystorePath.equals(this.myCustomKeystorePath) && ((Object)mvs.myAdditionalNativeLibs).equals(this.myAdditionalNativeLibs);
        }

        public void save(DataOutput out) throws IOException {
            out.writeInt(this.myResourceTimestamps.size());
            for (Map.Entry<String, Long> entry : this.myResourceTimestamps.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeLong(entry.getValue());
            }
            out.writeBoolean(this.myGenerateUnsignedApk);
            out.writeBoolean(this.myReleaseBuild);
            out.writeUTF(this.myApkPath);
            CompilerIOUtil.writeString((String)this.myCustomKeystorePath, (DataOutput)out);
            out.writeInt(this.myAdditionalNativeLibs.size());
            for (Map.Entry<String, Long> entry : this.myAdditionalNativeLibs.entrySet()) {
                AndroidNativeLibData lib = (AndroidNativeLibData)entry.getKey();
                out.writeUTF(lib.getArchitecture());
                out.writeUTF(lib.getPath());
                out.writeUTF(lib.getTargetFileName());
                out.writeLong(entry.getValue());
            }
        }
    }

    private static class AptPackagingItem
    implements FileProcessingCompiler.ProcessingItem {
        private final String mySdkPath;
        private final VirtualFile myManifestFile;
        private final String myResPackagePath;
        private final String myFinalPath;
        private String myClassesDexPath;
        private VirtualFile[] myNativeLibsFolders;
        private final List<AndroidNativeLibData> myAdditionalNativeLibs;
        private VirtualFile[] mySourceRoots;
        private VirtualFile[] myExternalLibraries;
        private final boolean myGenerateUnsigendApk;
        private final Module myModule;
        private boolean myReleaseBuild;
        private final String myCustomKeystorePath;

        private AptPackagingItem(String sdkPath, @NotNull VirtualFile manifestFile, @NotNull String resPackagePath, @NotNull String finalPath, boolean generateUnsigendApk, boolean releaseBuild, @NotNull Module module, @Nullable String customKeystorePath, @NotNull List<AndroidNativeLibData> additionalNativeLibs) {
            if (manifestFile == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "<init>"));
            }
            if (resPackagePath == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "<init>"));
            }
            if (finalPath == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "<init>"));
            }
            if (additionalNativeLibs == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "8", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "<init>"));
            }
            this.mySdkPath = sdkPath;
            this.myManifestFile = manifestFile;
            this.myResPackagePath = resPackagePath;
            this.myFinalPath = finalPath;
            this.myGenerateUnsigendApk = generateUnsigendApk;
            this.myReleaseBuild = releaseBuild;
            this.myModule = module;
            this.myCustomKeystorePath = customKeystorePath;
            this.myAdditionalNativeLibs = additionalNativeLibs;
        }

        @NotNull
        public String getResPackagePath() {
            String string = this.myResPackagePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "getResPackagePath"));
            }
            return string;
        }

        @NotNull
        public String getFinalPath() {
            String string = this.myFinalPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "getFinalPath"));
            }
            return string;
        }

        @NotNull
        public String getClassesDexPath() {
            String string = this.myClassesDexPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "getClassesDexPath"));
            }
            return string;
        }

        @Nullable
        public String getCustomKeystorePath() {
            return this.myCustomKeystorePath;
        }

        @NotNull
        public VirtualFile[] getNativeLibsFolders() {
            if (this.myNativeLibsFolders == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "getNativeLibsFolders"));
            }
            return this.myNativeLibsFolders;
        }

        @NotNull
        public List<AndroidNativeLibData> getAdditionalNativeLibs() {
            List<AndroidNativeLibData> list = this.myAdditionalNativeLibs;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "getAdditionalNativeLibs"));
            }
            return list;
        }

        @NotNull
        public VirtualFile[] getSourceRoots() {
            if (this.mySourceRoots == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "getSourceRoots"));
            }
            return this.mySourceRoots;
        }

        @NotNull
        public VirtualFile[] getExternalLibraries() {
            if (this.myExternalLibraries == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "getExternalLibraries"));
            }
            return this.myExternalLibraries;
        }

        public void setSourceRoots(@NotNull VirtualFile[] sourceRoots) {
            if (sourceRoots == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "setSourceRoots"));
            }
            this.mySourceRoots = sourceRoots;
        }

        public void setExternalLibraries(@NotNull VirtualFile[] externalLibraries) {
            if (externalLibraries == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "setExternalLibraries"));
            }
            this.myExternalLibraries = externalLibraries;
        }

        public void setClassesDexPath(@NotNull String classesDexPath) {
            if (classesDexPath == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "setClassesDexPath"));
            }
            this.myClassesDexPath = classesDexPath;
        }

        public void setNativeLibsFolders(@NotNull VirtualFile[] nativeLibsFolders) {
            if (nativeLibsFolders == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "setNativeLibsFolders"));
            }
            this.myNativeLibsFolders = nativeLibsFolders;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myManifestFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPackagingCompiler$AptPackagingItem", "getFile"));
            }
            return virtualFile;
        }

        @Nullable
        public ValidityState getValidityState() {
            return new MyValidityState(this.myModule.getProject(), this.myResPackagePath, this.myClassesDexPath, this.myFinalPath, this.myGenerateUnsigendApk, this.myReleaseBuild, this.mySourceRoots, this.myExternalLibraries, this.myNativeLibsFolders, this.myCustomKeystorePath, this.myAdditionalNativeLibs);
        }
    }
}

