/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.GeneratingCompiler;
import com.intellij.openapi.compiler.SourceGeneratingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.ResourceNamesValidityState;
import org.jetbrains.android.compiler.tools.AndroidMavenExecutor;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.maven.AndroidMavenProvider;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class AndroidMavenResourcesCompiler
implements SourceGeneratingCompiler {
    private static final GeneratingCompiler.GenerationItem[] EMPTY_GENERATION_ITEM_ARRAY = new GeneratingCompiler.GenerationItem[0];

    public VirtualFile getPresentableFile(CompileContext context, Module module, VirtualFile outputRoot, VirtualFile generatedFile) {
        return null;
    }

    public GeneratingCompiler.GenerationItem[] getGenerationItems(CompileContext context) {
        return (GeneratingCompiler.GenerationItem[])ApplicationManager.getApplication().runReadAction((Computable)new PrepareAction(context));
    }

    public GeneratingCompiler.GenerationItem[] generate(final CompileContext context, final GeneratingCompiler.GenerationItem[] items, VirtualFile outputRootDirectory) {
        if (items != null && items.length > 0) {
            context.getProgressIndicator().setText("Processing resources by Maven...");
            Computable<GeneratingCompiler.GenerationItem[]> computation = new Computable<GeneratingCompiler.GenerationItem[]>(){

                public GeneratingCompiler.GenerationItem[] compute() {
                    if (context.getProject().isDisposed()) {
                        return EMPTY_GENERATION_ITEM_ARRAY;
                    }
                    return AndroidMavenResourcesCompiler.doGenerate(context, items);
                }
            };
            GeneratingCompiler.GenerationItem[] generationItems = (GeneratingCompiler.GenerationItem[])computation.compute();
            ArrayList<VirtualFile> generatedVFiles = new ArrayList<VirtualFile>();
            for (GeneratingCompiler.GenerationItem item : generationItems) {
                VirtualFile vFile;
                File generatedFile = ((MyGenerationItem)item).myGeneratedFile;
                if (generatedFile == null || (vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(generatedFile)) == null) continue;
                AndroidCompileUtil.markDirtyAndRefresh(vFile, false);
                generatedVFiles.add(vFile);
            }
            if (context instanceof CompileContextEx) {
                ((CompileContextEx)context).markGenerated(generatedVFiles);
            }
            return generationItems;
        }
        return EMPTY_GENERATION_ITEM_ARRAY;
    }

    private static GeneratingCompiler.GenerationItem[] doGenerate(CompileContext context, GeneratingCompiler.GenerationItem[] items) {
        ArrayList<MyGenerationItem> results = new ArrayList<MyGenerationItem>(items.length);
        for (GeneratingCompiler.GenerationItem item : items) {
            if (!(item instanceof MyGenerationItem)) continue;
            final MyGenerationItem genItem = (MyGenerationItem)item;
            if (!AndroidCompileUtil.isModuleAffected(context, genItem.myModule)) continue;
            Map<CompilerMessageCategory, List<String>> messages = AndroidMavenExecutor.generateResources(genItem.myModule);
            AndroidCompileUtil.addMessages(context, messages, genItem.myModule);
            if (messages.get(CompilerMessageCategory.ERROR).isEmpty()) {
                results.add(genItem);
            }
            if (!genItem.myGeneratedFile.exists()) continue;
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    String className = FileUtil.getNameWithoutExtension((File)genItem.myGeneratedFile);
                    AndroidCompileUtil.removeDuplicatingClasses(genItem.myModule, genItem.myPackage, className, genItem.myGeneratedFile, genItem.mySourceRootPath);
                }
            });
        }
        return results.toArray(new GeneratingCompiler.GenerationItem[results.size()]);
    }

    @NotNull
    public String getDescription() {
        if ("Android Maven Resources Compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidMavenResourcesCompiler", "getDescription"));
        }
        return "Android Maven Resources Compiler";
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput is) throws IOException {
        return new MyValidityState(is);
    }

    private static final class PrepareAction
    implements Computable<GeneratingCompiler.GenerationItem[]> {
        private final CompileContext myContext;

        public PrepareAction(CompileContext context) {
            this.myContext = context;
        }

        public GeneratingCompiler.GenerationItem[] compute() {
            if (this.myContext.getProject().isDisposed()) {
                return EMPTY_GENERATION_ITEM_ARRAY;
            }
            Module[] modules = ModuleManager.getInstance((Project)this.myContext.getProject()).getModules();
            ArrayList<MyGenerationItem> items = new ArrayList<MyGenerationItem>();
            for (Module module : modules) {
                String aPackage;
                MavenProject mavenProject;
                AndroidFacet facet;
                MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)this.myContext.getProject());
                if (mavenProjectsManager == null || !mavenProjectsManager.isMavenizedModule(module) || (facet = AndroidFacet.getInstance(module)) == null || !facet.getProperties().RUN_PROCESS_RESOURCES_MAVEN_TASK || (mavenProject = mavenProjectsManager.findProject(module)) == null) continue;
                Manifest manifest = facet.getManifest();
                String string = aPackage = manifest != null ? (String)manifest.getPackage().getValue() : null;
                if (aPackage == null) {
                    VirtualFile manifestFile = AndroidRootUtil.getManifestFile(facet);
                    this.myContext.addMessage(CompilerMessageCategory.ERROR, "Cannot find package value in AndroidManifest.xml for module " + module.getName(), manifestFile != null ? manifestFile.getUrl() : null, -1, -1);
                    continue;
                }
                items.add(new MyGenerationItem(module, aPackage, mavenProject.getGeneratedSourcesDirectory(false) + "/r"));
            }
            return items.toArray(new GeneratingCompiler.GenerationItem[items.size()]);
        }
    }

    private static class MyValidityState
    extends ResourceNamesValidityState {
        private final long[] myMavenArtifactsTimespamps;

        private MyValidityState(Module module) {
            super(module);
            AndroidMavenProvider mavenProvider = AndroidMavenUtil.getMavenProvider();
            assert (mavenProvider != null);
            List<File> files = mavenProvider.getMavenDependencyArtifactFiles(module);
            this.myMavenArtifactsTimespamps = new long[files.size()];
            int filesSize = files.size();
            for (int i = 0; i < filesSize; ++i) {
                this.myMavenArtifactsTimespamps[i] = files.get(i).lastModified();
            }
        }

        public MyValidityState(DataInput is) throws IOException {
            super(is);
            int c = is.readInt();
            this.myMavenArtifactsTimespamps = new long[c];
            for (int i = 0; i < c; ++i) {
                this.myMavenArtifactsTimespamps[i] = is.readLong();
            }
        }

        @Override
        public boolean equalsTo(ValidityState otherState) {
            if (!super.equalsTo(otherState)) {
                return false;
            }
            if (!(otherState instanceof MyValidityState)) {
                return false;
            }
            return Arrays.equals(this.myMavenArtifactsTimespamps, ((MyValidityState)otherState).myMavenArtifactsTimespamps);
        }

        @Override
        public void save(DataOutput out) throws IOException {
            super.save(out);
            out.writeInt(this.myMavenArtifactsTimespamps.length);
            for (long timespamp : this.myMavenArtifactsTimespamps) {
                out.writeLong(timespamp);
            }
        }
    }

    private static final class MyGenerationItem
    implements GeneratingCompiler.GenerationItem {
        final Module myModule;
        final String myPackage;
        final File myGeneratedFile;
        final String mySourceRootPath;
        private final MyValidityState myValidityState;

        private MyGenerationItem(@NotNull Module module, @NotNull String aPackage, @NotNull String sourceRootPath) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidMavenResourcesCompiler$MyGenerationItem", "<init>"));
            }
            if (aPackage == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidMavenResourcesCompiler$MyGenerationItem", "<init>"));
            }
            if (sourceRootPath == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidMavenResourcesCompiler$MyGenerationItem", "<init>"));
            }
            this.myModule = module;
            this.myPackage = aPackage;
            this.myGeneratedFile = new File(sourceRootPath, aPackage.replace('.', File.separatorChar) + File.separator + "R.java");
            this.mySourceRootPath = sourceRootPath;
            this.myValidityState = new MyValidityState(this.myModule);
        }

        @Nullable
        public String getPath() {
            return this.myPackage.replace('.', '/') + '/' + "R.java";
        }

        public ValidityState getValidityState() {
            return this.myValidityState;
        }

        public Module getModule() {
            return this.myModule;
        }

        public boolean isTestSource() {
            return false;
        }
    }
}

