/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.GeneratingCompiler;
import com.intellij.openapi.compiler.SourceGeneratingCompiler;
import com.intellij.openapi.compiler.TimestampValidityState;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidIncludingCompiler
implements SourceGeneratingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidIncludingCompiler");

    @Nullable
    public VirtualFile getPresentableFile(CompileContext context, Module module, VirtualFile outputRoot, VirtualFile generatedFile) {
        String generatedFileRelativePath = VfsUtilCore.getRelativePath((VirtualFile)generatedFile, (VirtualFile)outputRoot, (char)'/');
        if (generatedFileRelativePath == null) {
            return null;
        }
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(module, true)) {
            VirtualFile[] srcRoots;
            String genSrcRootPath = AndroidRootUtil.getAptGenSourceRootPath(depFacet);
            VirtualFile genSrcRoot = genSrcRootPath != null ? LocalFileSystem.getInstance().findFileByPath(genSrcRootPath) : null;
            for (VirtualFile depSourceRoot : srcRoots = ModuleRootManager.getInstance((Module)depFacet.getModule()).getSourceRoots()) {
                VirtualFile file;
                if (Comparing.equal((Object)depSourceRoot, (Object)genSrcRoot) || (file = depSourceRoot.findFileByRelativePath(generatedFileRelativePath)) == null) continue;
                return file;
            }
        }
        return null;
    }

    public GeneratingCompiler.GenerationItem[] getGenerationItems(final CompileContext context) {
        return (GeneratingCompiler.GenerationItem[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<GeneratingCompiler.GenerationItem[]>(){

            public GeneratingCompiler.GenerationItem[] compute() {
                ArrayList result = new ArrayList();
                for (Module module : context.getProjectCompileScope().getAffectedModules()) {
                    AndroidFacet facet = AndroidFacet.getInstance(module);
                    if (facet != null && facet.isLibraryProject()) continue;
                    HashMap qName2Item = new HashMap();
                    for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(module, true)) {
                        VirtualFile[] srcRoots;
                        AndroidPlatform platform = ((AndroidFacetConfiguration)depFacet.getConfiguration()).getAndroidPlatform();
                        int platformToolsRevision = platform != null ? platform.getSdkData().getPlatformToolsRevision() : -1;
                        if (platformToolsRevision < 0 || platformToolsRevision > 7) continue;
                        String aptGenSrcRootPath = AndroidRootUtil.getAptGenSourceRootPath(depFacet);
                        VirtualFile aptGenSrcRoot = aptGenSrcRootPath != null ? LocalFileSystem.getInstance().findFileByPath(aptGenSrcRootPath) : null;
                        String aidlGenSrcRootPath = AndroidRootUtil.getAidlGenSourceRootPath(depFacet);
                        VirtualFile aidlGenSrcRoot = aidlGenSrcRootPath != null ? LocalFileSystem.getInstance().findFileByPath(aidlGenSrcRootPath) : null;
                        for (VirtualFile depSourceRoot : srcRoots = ModuleRootManager.getInstance((Module)depFacet.getModule()).getSourceRoots()) {
                            if (Comparing.equal((Object)depSourceRoot, (Object)aptGenSrcRoot) || Comparing.equal((Object)depSourceRoot, (Object)aidlGenSrcRoot)) continue;
                            AndroidIncludingCompiler.collectCompilableFiles(module, depFacet.getModule(), context, depSourceRoot, (Map)qName2Item);
                        }
                    }
                    result.addAll(qName2Item.values());
                }
                return result.toArray(new MyItem[result.size()]);
            }
        });
    }

    private static void collectCompilableFiles(final Module module, Module depModule, final CompileContext context, final @NotNull VirtualFile sourceRoot, final Map<String, MyItem> relativePath2GenItem) {
        if (sourceRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/compiler/AndroidIncludingCompiler", "collectCompilableFiles"));
        }
        ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)depModule).getFileIndex();
        fileIndex.iterateContentUnderDirectory(sourceRoot, new ContentIterator(){

            public boolean processFile(VirtualFile fileOrDir) {
                if (fileOrDir.isDirectory()) {
                    return true;
                }
                if (fileOrDir.getFileType() == StdFileTypes.JAVA) {
                    String relativePath = VfsUtilCore.getRelativePath((VirtualFile)fileOrDir, (VirtualFile)sourceRoot, (char)'/');
                    LOG.assertTrue(relativePath != null);
                    MyItem existingItem = (MyItem)relativePath2GenItem.get(relativePath);
                    if (existingItem != null) {
                        String path1 = FileUtil.toSystemDependentName((String)existingItem.mySourceFile.getPath());
                        String path2 = FileUtil.toSystemDependentName((String)fileOrDir.getPath());
                        context.addMessage(CompilerMessageCategory.ERROR, "Duplicate file for " + relativePath + "\nOrigin 1: " + path1 + "\nOrigin 2: " + path2, null, -1, -1);
                        return false;
                    }
                    relativePath2GenItem.put(relativePath, new MyItem(module, fileOrDir, relativePath));
                }
                return true;
            }
        });
    }

    public GeneratingCompiler.GenerationItem[] generate(CompileContext context, GeneratingCompiler.GenerationItem[] items, VirtualFile outputRootDirectory) {
        if (items.length > 0) {
            context.getProgressIndicator().setText(AndroidBundle.message("android.compile.messages.copying.sources.from.libraries", new Object[0]));
        }
        ArrayList<GeneratingCompiler.GenerationItem> result = new ArrayList<GeneratingCompiler.GenerationItem>();
        boolean toRefresh = false;
        for (GeneratingCompiler.GenerationItem item : items) {
            if (!AndroidCompileUtil.isModuleAffected(context, ((MyItem)item).myModule)) continue;
            toRefresh = true;
            String fromPath = ((MyItem)item).mySourceFile.getPath();
            File from = new File(fromPath);
            File to = new File(outputRootDirectory.getPath() + '/' + item.getPath());
            try {
                FileUtil.copy((File)from, (File)to);
                result.add(item);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                String message = "Cannot copy file " + from.getPath() + " to " + to.getPath() + "\nI/O error" + (e.getMessage() != null ? ": " + e.getMessage() : "");
                context.addMessage(CompilerMessageCategory.ERROR, message, null, -1, -1);
            }
        }
        if (toRefresh) {
            AndroidCompileUtil.markDirtyAndRefresh(outputRootDirectory, true);
        }
        return result.toArray(new GeneratingCompiler.GenerationItem[result.size()]);
    }

    @NotNull
    public String getDescription() {
        if ("Android Including Compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidIncludingCompiler", "getDescription"));
        }
        return "Android Including Compiler";
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return TimestampValidityState.load((DataInput)in);
    }

    private static class MyItem
    implements GeneratingCompiler.GenerationItem {
        final Module myModule;
        final VirtualFile mySourceFile;
        final String mySourceRelativePath;
        private final TimestampValidityState myValidityState;

        private MyItem(Module module, VirtualFile sourceFile, String sourceRelativePath) {
            this.myModule = module;
            this.mySourceFile = sourceFile;
            this.mySourceRelativePath = sourceRelativePath;
            this.myValidityState = new TimestampValidityState(this.mySourceFile.getTimeStamp());
        }

        public String getPath() {
            return this.mySourceRelativePath;
        }

        @Nullable
        public ValidityState getValidityState() {
            return this.myValidityState;
        }

        public Module getModule() {
            return this.myModule;
        }

        public boolean isTestSource() {
            return false;
        }
    }
}

