/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.augment.ManifestInnerClass;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.Permission;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

class PermissionClass
extends ManifestInnerClass {
    PermissionClass(@NotNull AndroidFacet facet, @NotNull PsiClass context) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/augment/PermissionClass", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/augment/PermissionClass", "<init>"));
        }
        super(facet, "permission", context);
    }

    @Override
    @NotNull
    protected List<Pair<String, String>> doGetFields(@NotNull Manifest manifest) {
        if (manifest == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/augment/PermissionClass", "doGetFields"));
        }
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        for (Permission permission : manifest.getPermissions()) {
            int lastDotIndex;
            String lastId;
            String name = (String)permission.getName().getValue();
            if (name == null || name.length() <= 0 || (lastId = name.substring((lastDotIndex = name.lastIndexOf(46)) + 1)).length() <= 0) continue;
            result.add((Pair<String, String>)Pair.create((Object)AndroidResourceUtil.getFieldNameByResourceName(lastId), (Object)name));
        }
        ArrayList<Pair<String, String>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/PermissionClass", "doGetFields"));
        }
        return arrayList;
    }
}

