/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.SdkConstants;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.android.actions.AndroidRunSdkToolAction;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.ErrorReporter;
import org.jetbrains.android.util.ExecutionStatus;
import org.jetbrains.android.util.ProjectBasedErrorReporter;
import org.jetbrains.android.util.StringBuildingOutputProcessor;
import org.jetbrains.android.util.WaitingStrategies;
import org.jetbrains.annotations.NotNull;

public class RunAndroidAvdManagerAction
extends AndroidRunSdkToolAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.actions.RunAndroidAvdManagerAction");

    public RunAndroidAvdManagerAction() {
        super(RunAndroidAvdManagerAction.getName());
    }

    public RunAndroidAvdManagerAction(String name) {
        super(name);
    }

    public static String getName() {
        return AndroidBundle.message("android.run.avd.manager.action.text", new Object[0]);
    }

    @Override
    protected void doRunTool(@NotNull Project project, @NotNull String sdkPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/actions/RunAndroidAvdManagerAction", "doRunTool"));
        }
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/actions/RunAndroidAvdManagerAction", "doRunTool"));
        }
        RunAndroidAvdManagerAction.runAvdManager(sdkPath, new ProjectBasedErrorReporter(project), ModalityState.defaultModalityState());
    }

    public static void runAvdManager(final @NotNull String sdkPath, final @NotNull ErrorReporter errorReporter, final @NotNull ModalityState modalityState) {
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/actions/RunAndroidAvdManagerAction", "runAvdManager"));
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/actions/RunAndroidAvdManagerAction", "runAvdManager"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/actions/RunAndroidAvdManagerAction", "runAvdManager"));
        }
        final ProgressWindow p = new ProgressWindow(false, true, null);
        p.setIndeterminate(false);
        p.setDelayInMillis(0);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StringBuildingOutputProcessor processor;
                block9: {
                    String toolPath = sdkPath + File.separator + AndroidCommonUtils.toolPath((String)SdkConstants.androidCmdName());
                    GeneralCommandLine commandLine = new GeneralCommandLine();
                    commandLine.setExePath(toolPath);
                    commandLine.addParameter("avd");
                    processor = new StringBuildingOutputProcessor();
                    try {
                        if (AndroidUtils.executeCommand(commandLine, processor, WaitingStrategies.WaitForTime.getInstance(1000)) != ExecutionStatus.TIMEOUT) break block9;
                        try {
                            p.start();
                            p.setText("Starting AVD Manager...");
                            for (double d = 0.0; d < 1.0; d += 0.05) {
                                p.setFraction(d);
                                Thread.sleep(100L);
                            }
                        }
                        catch (InterruptedException ignore) {
                        }
                        finally {
                            p.stop();
                        }
                        return;
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                        return;
                    }
                }
                final String message = processor.getMessage();
                if (message.toLowerCase().contains("error")) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            errorReporter.report("Cannot launch AVD manager.\nOutput:\n" + message, RunAndroidAvdManagerAction.getName());
                        }
                    }, modalityState);
                }
            }
        });
    }
}

