/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.uipreview.DeviceConfiguratorPanel;
import org.jetbrains.android.uipreview.InvalidOptionValueException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateResourceDirectoryDialog
extends DialogWrapper {
    private JComboBox myResourceTypeComboBox;
    private JPanel myDeviceConfiguratorWrapper;
    private JTextField myDirectoryNameTextField;
    private JPanel myContentPanel;
    private JBLabel myErrorLabel;
    private final DeviceConfiguratorPanel myDeviceConfiguratorPanel;
    private InputValidator myValidator;

    public CreateResourceDirectoryDialog(@NotNull Project project, @Nullable ResourceFolderType resType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/actions/CreateResourceDirectoryDialog", "<init>"));
        }
        super(project);
        this.$$$setupUI$$$();
        this.myResourceTypeComboBox.setModel(new EnumComboBoxModel(ResourceFolderType.class));
        this.myResourceTypeComboBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof ResourceFolderType) {
                    this.setText(((ResourceFolderType)value).getName());
                }
            }
        });
        this.myDeviceConfiguratorPanel = new DeviceConfiguratorPanel(){

            @Override
            public void applyEditors() {
                try {
                    this.doApplyEditors();
                    FolderConfiguration config = CreateResourceDirectoryDialog.this.myDeviceConfiguratorPanel.getConfiguration();
                    ResourceFolderType selectedResourceType = (ResourceFolderType)CreateResourceDirectoryDialog.this.myResourceTypeComboBox.getSelectedItem();
                    CreateResourceDirectoryDialog.this.myDirectoryNameTextField.setText(selectedResourceType != null ? config.getFolderName(selectedResourceType) : "");
                    CreateResourceDirectoryDialog.this.myErrorLabel.setText("");
                }
                catch (InvalidOptionValueException e) {
                    CreateResourceDirectoryDialog.this.myErrorLabel.setText("<html><body><font color=\"red\">" + e.getMessage() + "</font></body></html>");
                    CreateResourceDirectoryDialog.this.myDirectoryNameTextField.setText("");
                }
                CreateResourceDirectoryDialog.this.setOKActionEnabled(CreateResourceDirectoryDialog.this.myDirectoryNameTextField.getText().length() > 0);
            }
        };
        this.myDeviceConfiguratorWrapper.add((Component)this.myDeviceConfiguratorPanel, "Center");
        this.myResourceTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateResourceDirectoryDialog.this.myDeviceConfiguratorPanel.applyEditors();
            }
        });
        if (resType != null) {
            this.myResourceTypeComboBox.setSelectedItem(resType);
            this.myResourceTypeComboBox.setEnabled(false);
        }
        this.myDeviceConfiguratorPanel.updateAll();
        this.setOKActionEnabled(this.myDirectoryNameTextField.getText().length() > 0);
        this.init();
    }

    protected abstract InputValidator createValidator();

    protected void doOKAction() {
        String dirName = this.myDirectoryNameTextField.getText();
        assert (dirName != null);
        this.myValidator = this.createValidator();
        if (this.myValidator.checkInput(dirName) && this.myValidator.canClose(dirName)) {
            super.doOKAction();
        }
    }

    protected String getDimensionServiceKey() {
        return "AndroidCreateResourceDirectoryDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myResourceTypeComboBox.isEnabled()) {
            return this.myResourceTypeComboBox;
        }
        return this.myDirectoryNameTextField;
    }

    public InputValidator getValidator() {
        return this.myValidator;
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JTextField jTextField;
        JPanel jPanel;
        JComboBox jComboBox;
        JPanel jPanel2;
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setPreferredSize(new Dimension(800, 400));
        this.myResourceTypeComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Resource type:");
        jBLabel2.setDisplayedMnemonic('R');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeviceConfiguratorWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Directory name:");
        jLabel.setDisplayedMnemonic('D');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoryNameTextField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(true);
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myErrorLabel = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(3, 0, 1, 2, 0, 3, 0, 0, null, null, null));
        jBLabel2.setLabelFor(jComboBox);
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

