/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.intellij.CommonBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import java.io.File;
import org.jetbrains.android.actions.CreateResourceDirectoryDialog;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceDirectoryAction
extends CreateElementActionBase {
    private final ResourceFolderType myResourceFolderType;

    public CreateResourceDirectoryAction() {
        this(null);
    }

    public CreateResourceDirectoryAction(@Nullable ResourceFolderType resourceFolderType) {
        super(AndroidBundle.message("new.resource.dir.action.title", new Object[0]), AndroidBundle.message("new.resource.action.description", new Object[0]), PlatformIcons.DIRECTORY_CLOSED_ICON);
        this.myResourceFolderType = resourceFolderType;
    }

    @NotNull
    public PsiElement[] invokeDialog(final Project project, final PsiDirectory directory) {
        CreateResourceDirectoryDialog dialog = new CreateResourceDirectoryDialog(project, this.myResourceFolderType){

            @Override
            protected InputValidator createValidator() {
                return CreateResourceDirectoryAction.this.createValidator(project, directory);
            }
        };
        dialog.setTitle(AndroidBundle.message("new.resource.dir.dialog.title", new Object[0]));
        dialog.show();
        InputValidator validator = dialog.getValidator();
        if (validator == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceDirectoryAction", "invokeDialog"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = ((CreateElementActionBase.MyInputValidator)validator).getCreatedElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceDirectoryAction", "invokeDialog"));
        }
        return psiElementArray;
    }

    @NotNull
    private CreateElementActionBase.MyInputValidator createValidator(Project project, PsiDirectory resDir) {
        CreateElementActionBase.MyInputValidator myInputValidator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, resDir);
        if (myInputValidator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceDirectoryAction", "createValidator"));
        }
        return myInputValidator;
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        PsiElement[] psiElementArray = new PsiElement[]{directory.createSubdirectory(newName)};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceDirectoryAction", "create"));
        }
        return psiElementArray;
    }

    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    protected String getCommandName() {
        return AndroidBundle.message("new.resource.dir.command.name", new Object[0]);
    }

    @Nullable
    protected String getActionName(PsiDirectory directory, String newName) {
        return AndroidBundle.message("new.resource.dir.action.name", directory.getName() + File.separator + newName);
    }

    protected boolean isAvailable(DataContext context) {
        if (!super.isAvailable(context)) {
            return false;
        }
        final PsiElement element = (PsiElement)context.getData(CommonDataKeys.PSI_ELEMENT.getName());
        if (!(element instanceof PsiDirectory) || AndroidFacet.getInstance(element) == null) {
            return false;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return AndroidResourceUtil.isResourceDirectory((PsiDirectory)element);
            }
        });
    }
}

