/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameJavaVariableProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameXmlAttributeProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceRenameResourceProcessor
extends RenamePsiElementProcessor {
    public static volatile boolean ASK = true;

    public boolean canProcessElement(final @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidResourceRenameResourceProcessor", "canProcessElement"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                PsiClass cls;
                PsiElement element1 = LazyValueResourceElementWrapper.computeLazyElement(element);
                if (element1 == null) {
                    return false;
                }
                if (element1 instanceof PsiFile) {
                    return AndroidFacet.getInstance(element1) != null && AndroidResourceUtil.isInResourceSubdirectory((PsiFile)element1, null);
                }
                if (element1 instanceof PsiField) {
                    PsiField field = (PsiField)element1;
                    if (AndroidResourceUtil.isResourceField(field)) {
                        return AndroidResourceUtil.findResourcesByField(field).size() > 0;
                    }
                } else if (element1 instanceof XmlAttributeValue) {
                    LocalResourceManager manager = LocalResourceManager.getInstance(element1);
                    if (manager != null) {
                        if (AndroidResourceUtil.isIdDeclaration((XmlAttributeValue)element1)) {
                            return true;
                        }
                        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element1, XmlTag.class);
                        return tag != null && DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag) instanceof ResourceElement && manager.getValueResourceType(tag) != null;
                    }
                } else if (element1 instanceof PsiClass && AndroidDomUtil.isInheritor(cls = (PsiClass)element1, "android.view.View")) {
                    return true;
                }
                return false;
            }
        });
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        PsiElement element1 = LazyValueResourceElementWrapper.computeLazyElement(element);
        if (element1 == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(element1);
        assert (facet != null);
        if (element1 instanceof PsiFile) {
            AndroidResourceRenameResourceProcessor.prepareResourceFileRenaming((PsiFile)element1, newName, allRenames, facet);
        } else if (element1 instanceof PsiClass) {
            PsiClass cls = (PsiClass)element1;
            if (AndroidDomUtil.isInheritor(cls, "android.view.View")) {
                AndroidResourceRenameResourceProcessor.prepareCustomViewRenaming(cls, newName, allRenames, facet);
            }
        } else if (element1 instanceof XmlAttributeValue) {
            XmlAttributeValue value = (XmlAttributeValue)element1;
            if (AndroidResourceUtil.isIdDeclaration(value)) {
                AndroidResourceRenameResourceProcessor.prepareIdRenaming(value, newName, allRenames, facet);
            } else {
                AndroidResourceRenameResourceProcessor.prepareValueResourceRenaming(element1, newName, allRenames, facet);
            }
        } else if (element1 instanceof PsiField) {
            AndroidResourceRenameResourceProcessor.prepareResourceFieldRenaming((PsiField)element1, newName, allRenames);
        }
    }

    private static void prepareCustomViewRenaming(PsiClass cls, String newName, Map<PsiElement, String> allRenames, AndroidFacet facet) {
        String oldName;
        AppResourceRepository appResources = AppResourceRepository.getAppResources(facet, true);
        if (appResources.hasResourceItem(ResourceType.DECLARE_STYLEABLE, oldName = cls.getName())) {
            LocalResourceManager manager = facet.getLocalResourceManager();
            for (PsiElement element : manager.findResourcesByFieldName(ResourceType.STYLEABLE.getName(), oldName)) {
                XmlTag tag;
                String tagName;
                if (!(element instanceof XmlAttributeValue) || !(element.getParent() instanceof XmlAttribute) || !(tagName = (tag = ((XmlAttribute)element.getParent()).getParent()).getName()).equals("declare-styleable")) continue;
                for (PsiField field : AndroidResourceUtil.findResourceFields(facet, ResourceType.STYLEABLE.getName(), oldName, false)) {
                    String escaped = AndroidResourceUtil.getFieldNameByResourceName(newName);
                    allRenames.put((PsiElement)field, escaped);
                }
                PsiField[] styleableFields = AndroidResourceUtil.findStyleableAttributeFields(tag, false);
                if (styleableFields.length <= 0) continue;
                for (PsiField resField : styleableFields) {
                    String fieldName = resField.getName();
                    String newAttributeName = fieldName.startsWith(oldName) ? newName + fieldName.substring(oldName.length()) : oldName;
                    String escaped = AndroidResourceUtil.getFieldNameByResourceName(newAttributeName);
                    allRenames.put((PsiElement)resField, escaped);
                }
            }
        }
    }

    private static void prepareIdRenaming(XmlAttributeValue value, String newName, Map<PsiElement, String> allRenames, AndroidFacet facet) {
        LocalResourceManager manager = facet.getLocalResourceManager();
        allRenames.remove(value);
        String id = AndroidResourceUtil.getResourceNameByReferenceText(value.getValue());
        assert (id != null);
        List<XmlAttributeValue> idDeclarations = manager.findIdDeclarations(id);
        for (XmlAttributeValue idDeclaration : idDeclarations) {
            if (!"id".equals(((XmlAttribute)idDeclaration.getParent()).getLocalName())) continue;
            allRenames.put(new ValueResourceElementWrapper(idDeclaration), newName);
        }
        String name = AndroidResourceUtil.getResourceNameByReferenceText(newName);
        if (name != null) {
            for (PsiField resField : AndroidResourceUtil.findIdFields(value)) {
                allRenames.put((PsiElement)resField, AndroidResourceUtil.getFieldNameByResourceName(name));
            }
        }
    }

    @Nullable
    private static String getResourceName(Project project, String newFieldName, String oldResourceName) {
        if (newFieldName.indexOf(95) < 0) {
            return newFieldName;
        }
        if (oldResourceName.indexOf(95) < 0 && oldResourceName.indexOf(46) >= 0) {
            String suggestion = newFieldName.replace('_', '.');
            newFieldName = Messages.showInputDialog((Project)project, (String)AndroidBundle.message("rename.resource.dialog.text", oldResourceName), (String)RefactoringBundle.message((String)"rename.title"), (Icon)Messages.getQuestionIcon(), (String)suggestion, null);
        }
        return newFieldName;
    }

    private static void prepareResourceFieldRenaming(PsiField field, String newName, Map<PsiElement, String> allRenames) {
        new RenameJavaVariableProcessor().prepareRenaming((PsiElement)field, newName, allRenames);
        List<PsiElement> resources = AndroidResourceUtil.findResourcesByField(field);
        PsiElement res = resources.get(0);
        String resName = res instanceof XmlAttributeValue ? ((XmlAttributeValue)res).getValue() : ((PsiFile)res).getName();
        String newResName = AndroidResourceRenameResourceProcessor.getResourceName(field.getProject(), newName, resName);
        for (PsiElement resource : resources) {
            XmlAttribute parent;
            XmlTag tag;
            if (resource instanceof PsiFile) {
                PsiFile file = (PsiFile)resource;
                String extension = FileUtilRt.getExtension((String)file.getName());
                allRenames.put(resource, newResName + '.' + extension);
                continue;
            }
            if (!(resource instanceof XmlAttributeValue)) continue;
            XmlAttributeValue value = (XmlAttributeValue)resource;
            String s = AndroidResourceUtil.isIdDeclaration(value) ? "@+id/" + newResName : newResName;
            allRenames.put(new ValueResourceElementWrapper(value), s);
            if (!(value.getParent() instanceof XmlAttribute) || !(tag = (parent = (XmlAttribute)value.getParent()).getParent()).getName().equals("declare-styleable")) continue;
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
            String oldName = tag.getAttributeValue("name");
            if (facet == null || oldName == null) continue;
            for (XmlTag attr : tag.getSubTags()) {
                String name;
                if (!attr.getName().equals("attr") || (name = attr.getAttributeValue("name")) == null) continue;
                String oldAttributeName = oldName + '_' + name;
                PsiField[] fields = AndroidResourceUtil.findResourceFields(facet, ResourceType.STYLEABLE.getName(), oldAttributeName, true);
                if (fields.length <= 0) continue;
                String newAttributeName = newName + '_' + name;
                for (PsiField f : fields) {
                    allRenames.put((PsiElement)f, newAttributeName);
                }
            }
        }
    }

    private static void prepareValueResourceRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames, AndroidFacet facet) {
        PsiField[] resFields;
        LocalResourceManager manager = facet.getLocalResourceManager();
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        assert (tag != null);
        String type = manager.getValueResourceType(tag);
        assert (type != null);
        Project project = tag.getProject();
        DomElement domElement = DomManager.getDomManager((Project)project).getDomElement(tag);
        assert (domElement instanceof ResourceElement);
        String name = (String)((ResourceElement)domElement).getName().getValue();
        assert (name != null);
        List<ResourceElement> resources = manager.findValueResources(type, name);
        for (ResourceElement resource : resources) {
            XmlAttributeValue xmlElement = resource.getName().getXmlAttributeValue();
            if (element.getManager().areElementsEquivalent(element, (PsiElement)xmlElement)) continue;
            allRenames.put((PsiElement)xmlElement, newName);
        }
        for (PsiField resField : resFields = AndroidResourceUtil.findResourceFieldsForValueResource(tag, false)) {
            String escaped = AndroidResourceUtil.getFieldNameByResourceName(newName);
            allRenames.put((PsiElement)resField, escaped);
        }
        PsiField[] styleableFields = AndroidResourceUtil.findStyleableAttributeFields(tag, false);
        if (styleableFields.length > 0) {
            boolean isAttr;
            String tagName = tag.getName();
            boolean isDeclareStyleable = tagName.equals("declare-styleable");
            boolean bl = isAttr = !isDeclareStyleable && tagName.equals("attr") && tag.getParentTag() != null;
            assert (isDeclareStyleable || isAttr);
            String style = isAttr ? tag.getParentTag().getAttributeValue("name") : null;
            for (PsiField resField : styleableFields) {
                String fieldName = resField.getName();
                String newAttributeName = isDeclareStyleable && fieldName.startsWith(name) ? newName + fieldName.substring(name.length()) : (isAttr && style != null ? style + '_' + newName : name);
                String escaped = AndroidResourceUtil.getFieldNameByResourceName(newAttributeName);
                allRenames.put((PsiElement)resField, escaped);
            }
        }
    }

    private static void prepareResourceFileRenaming(PsiFile file, String newName, Map<PsiElement, String> allRenames, AndroidFacet facet) {
        PsiField[] resFields;
        Project project = file.getProject();
        LocalResourceManager manager = facet.getLocalResourceManager();
        String type = manager.getFileResourceType(file);
        if (type == null) {
            return;
        }
        String name = file.getName();
        if (AndroidCommonUtils.getResourceName((String)type, (String)name).equals(AndroidCommonUtils.getResourceName((String)type, (String)newName))) {
            return;
        }
        List<PsiFile> resourceFiles = manager.findResourceFiles(type, AndroidCommonUtils.getResourceName((String)type, (String)name), true, false, new String[0]);
        ArrayList<PsiFile> alternativeResources = new ArrayList<PsiFile>();
        for (PsiFile resourceFile : resourceFiles) {
            if (resourceFile.getManager().areElementsEquivalent((PsiElement)file, (PsiElement)resourceFile) || !resourceFile.getName().equals(name)) continue;
            alternativeResources.add(resourceFile);
        }
        if (alternativeResources.size() > 0) {
            int r = 0;
            if (ASK) {
                r = Messages.showDialog((Project)project, (String)AndroidBundle.message("rename.alternate.resources.question", new Object[0]), (String)AndroidBundle.message("rename.dialog.title", new Object[0]), (String[])new String[]{Messages.YES_BUTTON, Messages.NO_BUTTON}, (int)1, (Icon)Messages.getQuestionIcon());
            }
            if (r == 0) {
                for (PsiFile candidate : alternativeResources) {
                    allRenames.put((PsiElement)candidate, newName);
                }
            } else {
                return;
            }
        }
        for (PsiField resField : resFields = AndroidResourceUtil.findResourceFieldsForFileResource(file, false)) {
            String newFieldName = AndroidCommonUtils.getResourceName((String)type, (String)newName);
            allRenames.put((PsiElement)resField, AndroidResourceUtil.getFieldNameByResourceName(newFieldName));
        }
    }

    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        if (element instanceof PsiField) {
            new RenameJavaVariableProcessor().renameElement(element, newName, usages, listener);
        } else if (element instanceof PsiNamedElement) {
            VirtualFile virtualFile;
            super.renameElement(element, newName, usages, listener);
            if (element instanceof PsiFile && (virtualFile = ((PsiFile)element).getVirtualFile()) != null && !LocalHistory.getInstance().isUnderControl(virtualFile)) {
                DocumentReference ref = DocumentReferenceManager.getInstance().create(virtualFile);
                UndoManager.getInstance((Project)element.getProject()).nonundoableActionPerformed(ref, false);
            }
        } else if (element instanceof XmlAttributeValue) {
            new RenameXmlAttributeProcessor().renameElement(element, newName, usages, listener);
        }
    }
}

