/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.annotations.Nullable;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.android.AndroidUsagesTargetProvider;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidRenameHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return false;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return false;
        }
        if (AndroidUsagesTargetProvider.findValueResourceTagInContext(editor, file) != null) {
            return true;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        return element != null && AndroidRenameHandler.isPackageAttributeInManifest(project, element);
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidRenameHandler", "invoke"));
        }
        if (file == null || editor == null) {
            return;
        }
        XmlTag tag = AndroidUsagesTargetProvider.findValueResourceTagInContext(editor, file);
        if (tag != null) {
            AndroidRenameHandler.performValueResourceRenaming(project, editor, dataContext, tag);
        } else {
            AndroidRenameHandler.performApplicationPackageRenaming(project, editor, dataContext);
        }
    }

    private static void performValueResourceRenaming(Project project, Editor editor, DataContext dataContext, XmlTag tag) {
        XmlAttribute nameAttribute = tag.getAttribute("name");
        if (nameAttribute == null) {
            return;
        }
        XmlAttributeValue attributeValue = nameAttribute.getValueElement();
        if (attributeValue == null) {
            return;
        }
        RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)new RenameDialog(project, (PsiElement)new ValueResourceElementWrapper(attributeValue), null, editor));
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidRenameHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/AndroidRenameHandler", "invoke"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return;
        }
        this.invoke(project, editor, file, dataContext);
    }

    public String getActionTitle() {
        return "Rename Android value resource";
    }

    static boolean isPackageAttributeInManifest(@NotNull Project project, @Nullable PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidRenameHandler", "isPackageAttributeInManifest"));
        }
        PsiFile psiFile = element.getContainingFile();
        if (!(psiFile instanceof XmlFile)) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)psiFile);
        if (facet == null) {
            return false;
        }
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null || !vFile.equals(AndroidRootUtil.getManifestFile(facet))) {
            return false;
        }
        if (!(element instanceof XmlAttributeValue)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return false;
        }
        GenericAttributeValue attrValue = DomManager.getDomManager((Project)project).getDomElement((XmlAttribute)parent);
        if (attrValue == null) {
            return false;
        }
        DomElement parentDomElement = attrValue.getParent();
        return parentDomElement instanceof Manifest && attrValue.equals(((Manifest)parentDomElement).getPackage());
    }

    private static void performApplicationPackageRenaming(@NotNull Project project, @NotNull Editor editor, @NotNull DataContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidRenameHandler", "performApplicationPackageRenaming"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/AndroidRenameHandler", "performApplicationPackageRenaming"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/AndroidRenameHandler", "performApplicationPackageRenaming"));
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (!(element instanceof XmlAttributeValue)) {
            return;
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        RenameDialog.showRenameDialog((DataContext)context, (RenameDialog)new RenameDialog(project, element, null, editor){

            @NotNull
            protected String getLabelText() {
                String string = "Rename Android application package of module '" + module.getName() + "' to:";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidRenameHandler$1", "getLabelText"));
                }
                return string;
            }

            protected void canRun() throws ConfigurationException {
                String name = this.getNewName();
                if (name.length() == 0) {
                    throw new ConfigurationException(AndroidBundle.message("specify.package.name.error", new Object[0]));
                }
                if (!AndroidUtils.isValidAndroidPackageName(name)) {
                    throw new ConfigurationException(AndroidBundle.message("not.valid.package.name.error", name));
                }
                if (!AndroidCommonUtils.contains2Identifiers((String)name)) {
                    throw new ConfigurationException(AndroidBundle.message("package.name.must.contain.2.ids.error", new Object[0]));
                }
                super.canRun();
            }
        });
    }
}

