/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidPrecompileTask;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidResourceFilesListener;
import org.jetbrains.annotations.NotNull;

public class AndroidProjectComponent
extends AbstractProjectComponent {
    private Disposable myDisposable;

    protected AndroidProjectComponent(Project project) {
        super(project);
    }

    public void projectOpened() {
        CompilerManager manager = CompilerManager.getInstance((Project)this.myProject);
        manager.addBeforeTask((CompileTask)new AndroidPrecompileTask());
        this.myDisposable = new Disposable(){

            public void dispose() {
            }
        };
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            if (ProjectFacetManager.getInstance((Project)this.myProject).hasFacets(AndroidFacet.ID)) {
                this.createAndroidSpecificComponents();
            } else {
                final MessageBusConnection connection = this.myProject.getMessageBus().connect(this.myDisposable);
                connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

                    public void facetAdded(@NotNull Facet facet) {
                        if (facet == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidProjectComponent$2", "facetAdded"));
                        }
                        if (facet instanceof AndroidFacet) {
                            AndroidProjectComponent.this.createAndroidSpecificComponents();
                            connection.disconnect();
                        }
                    }
                });
            }
        }
    }

    public void projectClosed() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private void createAndroidSpecificComponents() {
        AndroidResourceFilesListener listener = new AndroidResourceFilesListener(this.myProject);
        Disposer.register((Disposable)this.myDisposable, (Disposable)listener);
        this.createAlarmForAutogeneration();
    }

    private void createAlarmForAutogeneration() {
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        alarm.addRequest(new Runnable(){

            @Override
            public void run() {
                Module[] modulesCopy;
                HashMap facetsToProcess = new HashMap();
                Module[] modules = ModuleManager.getInstance((Project)AndroidProjectComponent.this.myProject).getModules();
                for (Module module : modulesCopy = Arrays.copyOf(modules, modules.length)) {
                    AndroidFacet facet = AndroidFacet.getInstance(module);
                    if (facet == null || !facet.isAutogenerationEnabled()) continue;
                    EnumSet<AndroidAutogeneratorMode> modes = EnumSet.noneOf(AndroidAutogeneratorMode.class);
                    for (AndroidAutogeneratorMode mode : AndroidAutogeneratorMode.values()) {
                        if (!facet.cleanRegeneratingState(mode) && !facet.isGeneratedFileRemoved(mode)) continue;
                        modes.add(mode);
                    }
                    if (modes.size() <= 0) continue;
                    facetsToProcess.put(facet, modes);
                }
                if (facetsToProcess.size() > 0) {
                    AndroidProjectComponent.this.generate((Map)facetsToProcess);
                }
                if (!alarm.isDisposed()) {
                    alarm.addRequest((Runnable)this, 2000);
                }
            }
        }, 2000);
    }

    private void generate(final Map<AndroidFacet, Collection<AndroidAutogeneratorMode>> facetsToProcess) {
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AndroidCompileUtil.createGenModulesAndSourceRoots(AndroidProjectComponent.this.myProject, facetsToProcess.keySet());
            }
        }, ModalityState.defaultModalityState());
        for (Map.Entry<AndroidFacet, Collection<AndroidAutogeneratorMode>> entry : facetsToProcess.entrySet()) {
            AndroidFacet facet = entry.getKey();
            Collection<AndroidAutogeneratorMode> modes = entry.getValue();
            for (AndroidAutogeneratorMode mode : modes) {
                AndroidCompileUtil.doGenerate(facet, mode);
            }
        }
    }
}

