/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.PropertyTable;
import com.intellij.designer.propertyTable.PropertyTablePanel;
import com.intellij.designer.propertyTable.PropertyTableTab;
import com.intellij.designer.propertyTable.QuickFixManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThrowableRunnable;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadPropertyTable
extends PropertyTable
implements DataProvider,
ComponentSelectionListener {
    private final Project myProject;
    private EditableArea myArea;
    private DesignerEditorPanel myDesigner;
    private QuickFixManager myQuickFixManager;
    private PropertyTablePanel myPropertyTablePanel;
    private final ListSelectionListener myListener;

    public RadPropertyTable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/designer/propertyTable/RadPropertyTable", "<init>"));
        }
        this.myListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (RadPropertyTable.this.myDesigner != null) {
                    RadPropertyTable.this.myDesigner.setSelectionProperty(RadPropertyTable.this.getCurrentKey(), RadPropertyTable.this.getSelectionProperty());
                }
            }
        };
        this.setShowVerticalLines(true);
        this.setIntercellSpacing(new Dimension(1, 1));
        this.myProject = project;
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (RadPropertyTable.this.myPropertyTablePanel != null) {
                    RadPropertyTable.this.myPropertyTablePanel.updateActions();
                }
            }
        });
    }

    private void addSelectionListener() {
        this.getSelectionModel().addListSelectionListener(this.myListener);
    }

    private void removeSelectionListener() {
        this.getSelectionModel().removeListSelectionListener(this.myListener);
    }

    public void initQuickFixManager(JViewport viewPort) {
        this.myQuickFixManager = new QuickFixManager(this, viewPort);
    }

    public void setPropertyTablePanel(PropertyTablePanel propertyTablePanel) {
        this.myPropertyTablePanel = propertyTablePanel;
    }

    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.FILE_EDITOR.is(dataId) && this.myDesigner != null) {
            return this.myDesigner.getEditor();
        }
        return null;
    }

    protected List<ErrorInfo> getErrors(@NotNull PropertiesContainer container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/designer/propertyTable/RadPropertyTable", "getErrors"));
        }
        return container instanceof RadComponent ? RadComponent.getError((RadComponent)container) : Collections.emptyList();
    }

    @NotNull
    protected TextAttributesKey getErrorAttributes(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/designer/propertyTable/RadPropertyTable", "getErrorAttributes"));
        }
        TextAttributesKey textAttributesKey = SeverityRegistrar.getSeverityRegistrar((Project)this.myProject).getHighlightInfoTypeBySeverity(severity).getAttributesKey();
        if (textAttributesKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/propertyTable/RadPropertyTable", "getErrorAttributes"));
        }
        return textAttributesKey;
    }

    public void setArea(@Nullable DesignerEditorPanel designer, @Nullable EditableArea area) {
        this.myDesigner = designer;
        this.myQuickFixManager.setDesigner(designer);
        if (this.myArea != null) {
            this.myArea.removeSelectionListener(this);
        }
        this.myArea = area;
        if (this.myArea != null) {
            this.myArea.addSelectionListener(this);
        }
        this.update();
    }

    @Override
    public void selectionChanged(EditableArea area) {
        this.update();
    }

    public void updateInspections() {
        this.myQuickFixManager.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        try {
            this.removeSelectionListener();
            if (this.myArea == null) {
                this.update(Collections.emptyList(), null);
            } else {
                this.update(this.myArea.getSelection(), this.myDesigner.getSelectionProperty(this.getCurrentKey()));
            }
        }
        finally {
            this.addSelectionListener();
        }
    }

    @Nullable
    private String getCurrentKey() {
        PropertyTableTab tab = this.myPropertyTablePanel.getCurrentTab();
        return tab == null ? null : tab.getKey();
    }

    protected List<Property> getProperties(PropertiesContainer component) {
        PropertyTableTab tab = this.myPropertyTablePanel.getCurrentTab();
        if (tab != null) {
            return ((RadComponent)component).getProperties(tab.getKey());
        }
        return super.getProperties(component);
    }

    protected boolean doRestoreDefault(ThrowableRunnable<Exception> runnable) {
        return this.myDesigner.getToolProvider().execute(runnable, DesignerBundle.message("designer.properties.restore_default", new Object[0]), false);
    }

    protected boolean doSetValue(ThrowableRunnable<Exception> runnable) {
        return this.myDesigner.getToolProvider().execute(runnable, DesignerBundle.message("command.set.property.value", new Object[0]), false);
    }

    protected PropertyContext getPropertyContext() {
        return this.myDesigner;
    }
}

