/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.designSurface.tools.TargetingTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Cursor;
import java.awt.event.KeyEvent;

public class SelectionTracker
extends TargetingTool {
    protected final RadComponent myComponent;
    private boolean mySelected;

    public SelectionTracker(RadComponent component) {
        this.myComponent = component;
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.mySelected = false;
    }

    @Override
    protected Cursor calculateCursor() {
        return this.myState == 1 || this.myState == 2 ? this.getDefaultCursor() : super.calculateCursor();
    }

    @Override
    protected void handleButtonDown(int button) {
        if (!(this.myState != 1 || button != 1 && button != 3 || this.myArea.isSelected(this.myComponent))) {
            this.performSelection();
        }
        if (button == 1) {
            if (this.myState == 1) {
                this.myState = 2;
            }
        } else {
            this.myState = button == 3 ? 0 : 4;
            this.handleInvalidInput();
        }
    }

    @Override
    protected void handleButtonUp(int button) {
        if (this.myState == 2) {
            this.performSelection();
            this.myState = 0;
        }
    }

    @Override
    public void keyPressed(KeyEvent event, EditableArea area) throws Exception {
        super.keyPressed(event, area);
        if (event.getKeyCode() == 27) {
            this.myToolProvider.loadDefaultTool();
        }
    }

    private void performSelection() {
        if (this.mySelected || this.myArea.isTree()) {
            return;
        }
        this.mySelected = true;
        SelectionTracker.performSelection(this, this.myComponent);
    }

    public static void performSelection(InputTool tool, RadComponent component) {
        if (SystemInfo.isMac ? tool.myInputEvent.isMetaDown() : tool.myInputEvent.isControlDown()) {
            if (tool.myArea.isSelected(component)) {
                tool.myArea.deselect(component);
            } else {
                tool.myArea.appendSelection(component);
            }
        } else if (tool.myInputEvent.isShiftDown()) {
            tool.myArea.appendSelection(component);
        } else {
            tool.myArea.select(component);
        }
    }
}

