/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.StaticDecorator;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class DecorationLayer
extends JComponent {
    private final DesignerEditorPanel myDesigner;
    private final EditableArea myArea;
    private boolean myShowSelection = true;

    public DecorationLayer(DesignerEditorPanel designer, EditableArea area) {
        this.myDesigner = designer;
        this.myArea = area;
    }

    public EditableArea getArea() {
        return this.myArea;
    }

    public boolean showSelection() {
        return this.myShowSelection;
    }

    public void showSelection(boolean value) {
        if (this.myShowSelection != value) {
            this.myShowSelection = value;
            this.repaint();
        }
    }

    @Nullable
    public InputTool findTargetTool(int x, int y) {
        List<RadComponent> selection = this.myArea.getSelection();
        for (RadComponent component : selection) {
            ComponentDecorator decorator = this.getDecorator(component, selection);
            InputTool tracker = decorator.findTargetTool(this, component, x, y);
            if (tracker == null) continue;
            return tracker;
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        try {
            if (this.myArea.getRootComponent() != null) {
                Graphics2D g2d = (Graphics2D)g;
                this.paintStaticDecorators(g2d);
                if (this.myShowSelection) {
                    this.paintSelection(g2d);
                }
            }
        }
        catch (Throwable e) {
            this.myDesigner.showError("Paint operation", e);
        }
    }

    private void paintStaticDecorators(Graphics2D g) {
        final ArrayList decorators = new ArrayList();
        final List<RadComponent> selection = this.myArea.getSelection();
        this.myArea.getRootComponent().accept(new RadComponentVisitor(){

            @Override
            public void endVisit(RadComponent component) {
                component.addStaticDecorators(decorators, selection);
            }
        }, true);
        for (StaticDecorator decorator : decorators) {
            decorator.decorate(this, g);
        }
    }

    private void paintSelection(Graphics2D g) {
        List<RadComponent> selection = this.myArea.getSelection();
        for (RadComponent component : selection) {
            ComponentDecorator decorator = this.getDecorator(component, selection);
            decorator.decorate(this, g, component);
        }
    }

    private ComponentDecorator getDecorator(RadComponent component, List<RadComponent> selection) {
        RadComponent parent = component.getParent();
        if (parent == null) {
            return this.myArea.getRootSelectionDecorator();
        }
        return parent.getLayout().getChildSelectionDecorator(component, selection);
    }
}

