/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.DesignerEditorState;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DesignerEditor
extends UserDataHolderBase
implements FileEditor {
    private final DesignerEditorPanel myDesignerPanel;

    public DesignerEditor(Project project, VirtualFile file) {
        Module module;
        if (file instanceof LightVirtualFile) {
            file = ((LightVirtualFile)file).getOriginalFile();
        }
        if ((module = this.findModule(project, file)) == null) {
            throw new IllegalArgumentException("No module for file " + file + " in project " + project);
        }
        this.myDesignerPanel = this.createDesignerPanel(project, module, file);
    }

    @Nullable
    protected Module findModule(Project project, VirtualFile file) {
        return ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
    }

    @NotNull
    protected abstract DesignerEditorPanel createDesignerPanel(Project var1, Module var2, VirtualFile var3);

    public final DesignerEditorPanel getDesignerPanel() {
        return this.myDesignerPanel;
    }

    @NotNull
    public final JComponent getComponent() {
        DesignerEditorPanel designerEditorPanel = this.myDesignerPanel;
        if (designerEditorPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/DesignerEditor", "getComponent"));
        }
        return designerEditorPanel;
    }

    public final JComponent getPreferredFocusedComponent() {
        return this.myDesignerPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        if ("Design" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/DesignerEditor", "getName"));
        }
        return "Design";
    }

    public void dispose() {
        this.myDesignerPanel.dispose();
    }

    public void selectNotify() {
        this.myDesignerPanel.activate();
    }

    public void deselectNotify() {
        this.myDesignerPanel.deactivate();
    }

    public boolean isValid() {
        return this.myDesignerPanel.isEditorValid();
    }

    public boolean isModified() {
        return false;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/designer/DesignerEditor", "getState"));
        }
        DesignerEditorState designerEditorState = this.myDesignerPanel.createState();
        if (designerEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/DesignerEditor", "getState"));
        }
        return designerEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/designer/DesignerEditor", "setState"));
        }
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/designer/DesignerEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/designer/DesignerEditor", "removePropertyChangeListener"));
        }
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }
}

