/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.android.resources.ResourceType;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.IXmlAttributeLocator;
import com.intellij.android.designer.propertyTable.JavadocParser;
import com.intellij.android.designer.propertyTable.editors.ResourceEditor;
import com.intellij.android.designer.propertyTable.renderers.ResourceRenderer;
import com.intellij.designer.model.Property;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import java.util.Collections;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleProperty
extends Property<RadViewComponent>
implements IXmlAttributeLocator {
    public static final ResourceType[] STYLE_TYPES = new ResourceType[]{ResourceType.STYLE};
    private final PropertyRenderer myRenderer = new ResourceRenderer(Collections.<AttributeFormat>emptySet());
    private final PropertyEditor myEditor = new ResourceEditor(STYLE_TYPES, Collections.<AttributeFormat>emptySet(), null);
    private final String myJavadocText = JavadocParser.build("style", "A reference to a custom style");

    public StyleProperty() {
        super(null, "style");
        this.setImportant(true);
    }

    public Property<RadViewComponent> createForNewPresentation(@Nullable Property parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/android/designer/propertyTable/StyleProperty", "createForNewPresentation"));
        }
        return null;
    }

    @NotNull
    public PropertyRenderer getRenderer() {
        PropertyRenderer propertyRenderer = this.myRenderer;
        if (propertyRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/StyleProperty", "getRenderer"));
        }
        return propertyRenderer;
    }

    public PropertyEditor getEditor() {
        return this.myEditor;
    }

    public Object getValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/StyleProperty", "getValue"));
        }
        String value = null;
        XmlAttribute attribute = StyleProperty.getAttribute(component);
        if (attribute != null) {
            value = attribute.getValue();
        }
        return value == null ? "" : value;
    }

    public void setValue(final @NotNull RadViewComponent component, final Object value) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/StyleProperty", "setValue"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (StringUtil.isEmpty((String)((String)value))) {
                    XmlAttribute attribute = StyleProperty.getAttribute(component);
                    if (attribute != null) {
                        attribute.delete();
                    }
                } else {
                    component.getTag().setAttribute("style", (String)value);
                }
            }
        });
    }

    public boolean isDefaultValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/StyleProperty", "isDefaultValue"));
        }
        return StyleProperty.getAttribute(component) == null;
    }

    public void setDefaultValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/StyleProperty", "setDefaultValue"));
        }
        if (StyleProperty.getAttribute(component) != null) {
            this.setValue(component, (Object)null);
        }
    }

    @Nullable
    private static XmlAttribute getAttribute(RadViewComponent component) {
        return component.getTag().getAttribute("style");
    }

    @Override
    public boolean checkAttribute(RadViewComponent component, XmlAttribute attribute) {
        return StyleProperty.getAttribute(component) == attribute;
    }

    public String getJavadocText() {
        return this.myJavadocText;
    }
}

