/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.IXmlAttributeLocator;
import com.intellij.android.designer.propertyTable.JavadocParser;
import com.intellij.android.designer.propertyTable.PropertyWithNamespace;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.Property;
import com.intellij.designer.propertyTable.IPropertyDecorator;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.editors.BooleanEditor;
import com.intellij.designer.propertyTable.renderers.BooleanRenderer;
import com.intellij.designer.propertyTable.renderers.LabelPropertyRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlagProperty
extends PropertyWithNamespace
implements IPropertyDecorator,
IXmlAttributeLocator {
    private final PropertyRenderer myRenderer;
    protected final AttributeDefinition myDefinition;
    protected final List<Property<RadViewComponent>> myOptions;
    private String myJavadocText;

    public FlagProperty(@NotNull String name, @NotNull AttributeDefinition definition) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/FlagProperty", "<init>"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/android/designer/propertyTable/FlagProperty", "<init>"));
        }
        super(null, name);
        this.myRenderer = new LabelPropertyRenderer(null);
        this.myOptions = new ArrayList<Property<RadViewComponent>>();
        this.myDefinition = definition;
        for (String option : definition.getValues()) {
            this.myOptions.add(new OptionProperty(this, option, option));
        }
    }

    @Override
    protected String getAttributeName() {
        return this.myDefinition.getName();
    }

    public Property<RadViewComponent> createForNewPresentation(@Nullable Property parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/android/designer/propertyTable/FlagProperty", "createForNewPresentation"));
        }
        return new FlagProperty(name, this.myDefinition);
    }

    @Override
    public void decorate(@NotNull MetaModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/FlagProperty", "decorate"));
        }
        String name = this.getName();
        for (Property<RadViewComponent> option : this.myOptions) {
            model.decorate(option, name + "." + option.getName());
        }
    }

    @NotNull
    public List<Property<RadViewComponent>> getChildren(@Nullable RadViewComponent component) {
        List<Property<RadViewComponent>> list = this.myOptions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/FlagProperty", "getChildren"));
        }
        return list;
    }

    public Object getValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/FlagProperty", "getValue"));
        }
        StringBuilder value = new StringBuilder("[");
        Set<String> options = this.getOptions(component);
        int index = 0;
        for (Property<RadViewComponent> option : this.myOptions) {
            if (!options.contains(((OptionProperty)option).getValueName())) continue;
            if (index++ > 0) {
                value.append(", ");
            }
            value.append(option.getName());
        }
        return value.append("]").toString();
    }

    public boolean isDefaultValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/FlagProperty", "isDefaultValue"));
        }
        return this.getAttribute(component) == null;
    }

    public void setDefaultValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/FlagProperty", "setDefaultValue"));
        }
        final XmlAttribute attribute = this.getAttribute(component);
        if (attribute != null) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    attribute.delete();
                }
            });
        }
    }

    @NotNull
    public PropertyRenderer getRenderer() {
        PropertyRenderer propertyRenderer = this.myRenderer;
        if (propertyRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/FlagProperty", "getRenderer"));
        }
        return propertyRenderer;
    }

    public PropertyEditor getEditor() {
        return null;
    }

    @Nullable
    protected XmlAttribute getAttribute(RadViewComponent component) {
        return component.getTag().getAttribute(this.myDefinition.getName(), this.getNamespace(component, false));
    }

    @Override
    public boolean checkAttribute(RadViewComponent component, XmlAttribute attribute) {
        return this.getAttribute(component) == attribute;
    }

    protected Set<String> getOptions(RadViewComponent component) throws Exception {
        String value = component.getTag().getAttributeValue(this.myDefinition.getName(), this.getNamespace(component, false));
        if (value == null) {
            return Collections.emptySet();
        }
        HashSet<String> options = new HashSet<String>();
        for (String option : StringUtil.split((String)value, (String)"|")) {
            options.add(option.trim());
        }
        return options;
    }

    private boolean isOption(RadViewComponent component, String name) throws Exception {
        return this.getOptions(component).contains(name);
    }

    private void setOption(final RadViewComponent component, String name, boolean set) throws Exception {
        final HashSet<String> options = new HashSet<String>(this.getOptions(component));
        if (set ? !options.add(name) : !options.remove(name)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (options.isEmpty()) {
                    XmlAttribute attribute = FlagProperty.this.getAttribute(component);
                    if (attribute != null) {
                        attribute.delete();
                    }
                } else {
                    component.getTag().setAttribute(FlagProperty.this.myDefinition.getName(), FlagProperty.this.getNamespace(component, true), StringUtil.join((Collection)options, (String)"|"));
                }
            }
        });
    }

    public String getJavadocText() {
        String javadocText;
        if (this.myJavadocText == null && (javadocText = this.myDefinition.getDocValue(null)) != null) {
            this.myJavadocText = JavadocParser.build(this.getName(), javadocText);
        }
        return this.myJavadocText;
    }

    protected class OptionProperty
    extends Property<RadViewComponent> {
        private final PropertyRenderer myRenderer;
        private final PropertyEditor myEditor;
        private final String myValueName;

        public OptionProperty(@NotNull Property parent, @NotNull String name, String valueName) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/android/designer/propertyTable/FlagProperty$OptionProperty", "<init>"));
            }
            if (valueName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/android/designer/propertyTable/FlagProperty$OptionProperty", "<init>"));
            }
            super(parent, name);
            this.myRenderer = new BooleanRenderer();
            this.myEditor = new BooleanEditor();
            this.myValueName = valueName;
        }

        public String getValueName() {
            return this.myValueName;
        }

        public Property<RadViewComponent> createForNewPresentation(@Nullable Property parent, @NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/android/designer/propertyTable/FlagProperty$OptionProperty", "createForNewPresentation"));
            }
            return null;
        }

        public Object getValue(@NotNull RadViewComponent component) throws Exception {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/FlagProperty$OptionProperty", "getValue"));
            }
            return FlagProperty.this.isOption(component, this.myValueName);
        }

        public void setValue(@NotNull RadViewComponent component, Object value) throws Exception {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/FlagProperty$OptionProperty", "setValue"));
            }
            FlagProperty.this.setOption(component, this.myValueName, (Boolean)value);
        }

        public boolean isDefaultValue(@NotNull RadViewComponent component) throws Exception {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/FlagProperty$OptionProperty", "isDefaultValue"));
            }
            return !FlagProperty.this.isOption(component, this.myValueName);
        }

        public void setDefaultValue(@NotNull RadViewComponent component) throws Exception {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/FlagProperty$OptionProperty", "setDefaultValue"));
            }
            this.setValue(component, (Object)Boolean.FALSE);
        }

        @NotNull
        public PropertyRenderer getRenderer() {
            PropertyRenderer propertyRenderer = this.myRenderer;
            if (propertyRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/FlagProperty$OptionProperty", "getRenderer"));
            }
            return propertyRenderer;
        }

        public PropertyEditor getEditor() {
            return this.myEditor;
        }

        public boolean needRefreshPropertyList() {
            return true;
        }
    }
}

