/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.table;

import com.android.ide.common.rendering.api.ViewInfo;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.RadViewContainer;
import com.intellij.android.designer.model.grid.GridInfo;
import com.intellij.android.designer.model.grid.IGridProvider;
import com.intellij.android.designer.model.layout.table.RadTableRowLayout;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.List;

public class RadTableLayoutComponent
extends RadViewContainer
implements IGridProvider {
    private GridInfo myGridInfo;
    private GridInfo myVirtualGridInfo;

    @Override
    public void setViewInfo(ViewInfo viewInfo) {
        super.setViewInfo(viewInfo);
        this.myGridInfo = null;
        this.myVirtualGridInfo = null;
    }

    private int[] getColumnWidths() {
        try {
            Object viewObject = this.myViewInfo.getViewObject();
            Class<?> viewClass = viewObject.getClass();
            Field maxWidths = viewClass.getDeclaredField("mMaxWidths");
            maxWidths.setAccessible(true);
            int[] columnWidths = (int[])maxWidths.get(viewObject);
            return columnWidths == null ? ArrayUtil.EMPTY_INT_ARRAY : columnWidths;
        }
        catch (Throwable e) {
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
    }

    @Override
    public GridInfo getGridInfo() {
        if (this.myGridInfo == null) {
            List<RadComponent> rows;
            this.myGridInfo = new GridInfo(this);
            int[] columnWidths = this.getColumnWidths();
            if (columnWidths.length > 0) {
                this.myGridInfo.emptyColumns = new boolean[columnWidths.length];
                this.myGridInfo.vLines = new int[columnWidths.length + 1];
                for (int i = 0; i < columnWidths.length; ++i) {
                    int width = Math.max(columnWidths[i], 0);
                    boolean bl = this.myGridInfo.emptyColumns[i] = width == 0;
                    if (width == 0) {
                        width = 2;
                        if (i + 1 < columnWidths.length) {
                            int n = i + 1;
                            columnWidths[n] = columnWidths[n] - width;
                        }
                    }
                    this.myGridInfo.width += width;
                    this.myGridInfo.vLines[i + 1] = this.myGridInfo.width;
                }
            }
            if (!(rows = this.getChildren()).isEmpty()) {
                Rectangle bounds = this.getBounds();
                if (columnWidths.length == 0) {
                    this.myGridInfo.width = bounds.width;
                }
                this.myGridInfo.hLines = new int[rows.size() + 1];
                int index = 1;
                for (RadComponent row : rows) {
                    Rectangle rowBounds = row.getBounds();
                    this.myGridInfo.hLines[index++] = this.myGridInfo.height = rowBounds.y - bounds.y + rowBounds.height;
                }
            }
        }
        return this.myGridInfo;
    }

    @Override
    public GridInfo getVirtualGridInfo() {
        if (this.myVirtualGridInfo == null) {
            this.myVirtualGridInfo = new GridInfo(this);
            GridInfo gridInfo = this.getGridInfo();
            Rectangle bounds = this.getBounds();
            this.myVirtualGridInfo.width = bounds.width;
            this.myVirtualGridInfo.height = bounds.height;
            int deltaWidth = bounds.width - (gridInfo.vLines.length == 0 ? 0 : gridInfo.width);
            this.myVirtualGridInfo.vLines = GridInfo.addLineInfo(gridInfo.vLines, deltaWidth);
            int deltaHeight = bounds.height - gridInfo.height;
            this.myVirtualGridInfo.hLines = GridInfo.addLineInfo(gridInfo.hLines, deltaHeight);
            List<RadComponent> rows = this.getChildren();
            if (!rows.isEmpty()) {
                int columnSize = Math.max(1, gridInfo.vLines.length - 1);
                if (deltaWidth < 2) {
                    this.myVirtualGridInfo.lastInsertColumn = columnSize - 1;
                }
                if (deltaHeight < 2) {
                    this.myVirtualGridInfo.lastInsertRow = rows.size() - 1;
                }
                this.myVirtualGridInfo.components = this.getGridComponents(true);
            }
        }
        return this.myVirtualGridInfo;
    }

    public RadComponent[][] getGridComponents(boolean fillSpans) {
        GridInfo gridInfo = this.getGridInfo();
        List<RadComponent> rows = this.getChildren();
        int columnSize = Math.max(1, gridInfo.vLines.length - 1);
        RadComponent[][] components = new RadComponent[rows.size()][columnSize];
        for (int i = 0; i < components.length; ++i) {
            RadComponent row = rows.get(i);
            if (RadTableRowLayout.is(row)) {
                int index = 0;
                for (RadComponent column : row.getChildren()) {
                    int cellIndex = RadTableLayoutComponent.getCellIndex(column);
                    if (cellIndex > index) {
                        index = cellIndex;
                    }
                    int cellSpan = RadTableLayoutComponent.getCellSpan(column);
                    if (fillSpans) {
                        for (int j = 0; j < cellSpan; ++j) {
                            components[i][index++] = column;
                        }
                        continue;
                    }
                    components[i][index] = column;
                    index += cellSpan;
                }
                continue;
            }
            components[i][0] = row;
        }
        return components;
    }

    public static int getCellIndex(RadComponent component) {
        try {
            String column = ((RadViewComponent)component).getTag().getAttributeValue("layout_column", "http://schemas.android.com/apk/res/android");
            return Integer.parseInt(column);
        }
        catch (Throwable e) {
            return -1;
        }
    }

    public static int getCellSpan(RadComponent component) {
        try {
            String span = ((RadViewComponent)component).getTag().getAttributeValue("layout_span", "http://schemas.android.com/apk/res/android");
            return Integer.parseInt(span);
        }
        catch (Throwable e) {
            return 1;
        }
    }

    public static void setCellIndex(final RadComponent component, final int column) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                XmlTag tag = ((RadViewComponent)component).getTag();
                tag.setAttribute("layout_column", "http://schemas.android.com/apk/res/android", Integer.toString(column));
                RadComponentOperations.deleteAttribute(tag, "layout_span");
            }
        });
    }

    public static void setCellSpan(final RadComponent component, final int span) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                XmlTag tag = ((RadViewComponent)component).getTag();
                tag.setAttribute("layout_span", "http://schemas.android.com/apk/res/android", Integer.toString(span));
            }
        });
    }
}

